/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.media.jai.ROI;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.GridCoverage2DRIA;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.NumberRange;
import org.jaitools.imageutils.ROIGeometry;
import org.jaitools.media.jai.zonalstats.Result;
import org.jaitools.media.jai.zonalstats.ZonalStats;
import org.jaitools.media.jai.zonalstats.ZonalStatsOpImage;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

@DescribeProcess(title="Raster Zonal Statistics", description="Computes statistics for the distribution of a certain quantity in a set of polygonal zones.")
public class RasterZonalStatistics
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="statistics", description="A feature collection with the attributes of the zone layer (prefixed by 'z_') and the statistics fields count,min,max,sum,avg,stddev")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input raster to compute statistics for") GridCoverage2D coverage, @DescribeParameter(name="band", description="Source band used to compute statistics (default is 0)", min=0, defaultValue="0") Integer band, @DescribeParameter(name="zones", description="Zone polygon features for which to compute statistics") SimpleFeatureCollection zones, @DescribeParameter(name="classification", description="Raster whose values will be used as classes for the statistical analysis. Each zone reports statistics partitioned by classes according to the values of the raster. Must be a single band raster with integer values.", min=0) GridCoverage2D classification) {
        int iband = 0;
        if (band != null) {
            iband = band;
        }
        return new RasterZonalStatisticsCollection(coverage, iband, zones, classification);
    }

    static class RasterZonalStatisticsIterator
    implements SimpleFeatureIterator {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        SimpleFeatureIterator zones;
        SimpleFeatureBuilder builder;
        GridCoverage2D dataCoverage;
        int band;
        RenderedImage classificationRaster;
        List<SimpleFeature> features = new ArrayList<SimpleFeature>();

        public RasterZonalStatisticsIterator(SimpleFeatureIterator zones, GridCoverage2D coverage, int band, SimpleFeatureType targetSchema, GridCoverage2D classification) {
            this.zones = zones;
            this.builder = new SimpleFeatureBuilder(targetSchema);
            this.dataCoverage = coverage;
            this.band = band;
            if (classification != null) {
                double[] dArray;
                GridSampleDimension sampleDimension = classification.getSampleDimension(0);
                double[] nodataarr = sampleDimension.getNoDataValues();
                if (nodataarr != null) {
                    dArray = nodataarr;
                } else {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = Double.NaN;
                }
                double[] nodata = dArray;
                this.classificationRaster = GridCoverage2DRIA.create((GridCoverage2D)classification, (GridCoverage2D)this.dataCoverage, (double[])nodata);
            }
        }

        @Override
        public void close() {
            this.zones.close();
        }

        @Override
        public boolean hasNext() {
            return this.features.size() > 0 || this.zones.hasNext();
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (this.features.size() == 0) {
                SimpleFeature zone = (SimpleFeature)this.zones.next();
                try {
                    ZonalStats stats;
                    Geometry zoneGeom = (Geometry)zone.getDefaultGeometry();
                    CoordinateReferenceSystem dataCrs = this.dataCoverage.getCoordinateReferenceSystem();
                    CoordinateReferenceSystem zonesCrs = this.builder.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem();
                    if (!CRS.equalsIgnoreMetadata((Object)zonesCrs, (Object)dataCrs)) {
                        zoneGeom = JTS.transform(zoneGeom, CRS.findMathTransform((CoordinateReferenceSystem)zonesCrs, (CoordinateReferenceSystem)dataCrs, (boolean)true));
                    }
                    if ((stats = this.processStatistics(zoneGeom)) != null) {
                        if (this.classificationRaster != null) {
                            for (Integer classZoneId : stats.getZones()) {
                                this.builder.addAll(zone.getAttributes());
                                this.builder.add(classZoneId);
                                this.addStatsToFeature(stats.zone(classZoneId.intValue()));
                                this.features.add(this.builder.buildFeature(zone.getID()));
                            }
                        } else {
                            this.builder.addAll(zone.getAttributes());
                            this.addStatsToFeature(stats);
                            this.features.add(this.builder.buildFeature(zone.getID()));
                        }
                    } else {
                        this.builder.addAll(zone.getAttributes());
                        this.features.add(this.builder.buildFeature(zone.getID()));
                    }
                }
                catch (Exception e) {
                    throw new ProcessException("Failed to compute statistics on feature " + zone, e);
                }
            }
            SimpleFeature f = this.features.remove(0);
            return f;
        }

        void addStatsToFeature(ZonalStats stats) {
            double sum = ((Result)stats.statistic(Statistic.SUM).results().get(0)).getValue();
            double avg = ((Result)stats.statistic(Statistic.MEAN).results().get(0)).getValue();
            this.builder.add(Math.round(sum / avg));
            this.builder.add(((Result)stats.statistic(Statistic.MIN).results().get(0)).getValue());
            this.builder.add(((Result)stats.statistic(Statistic.MAX).results().get(0)).getValue());
            this.builder.add(sum);
            this.builder.add(avg);
            this.builder.add(((Result)stats.statistic(Statistic.SDEV).results().get(0)).getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ZonalStats processStatistics(Geometry geometry) throws TransformException {
            LinearTransform w2gTransform;
            AffineTransform dataG2WCorrected = new AffineTransform((AffineTransform)this.dataCoverage.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT));
            try {
                w2gTransform = ProjectiveTransform.create((AffineTransform)dataG2WCorrected.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
            GridCoverage2D cropped = null;
            try {
                ReferencedEnvelope coverageEnvelope = new ReferencedEnvelope((BoundingBox)this.dataCoverage.getEnvelope2D());
                ReferencedEnvelope geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), this.dataCoverage.getCoordinateReferenceSystem());
                if (!coverageEnvelope.intersects(geometryEnvelope)) {
                    ZonalStats zonalStats = null;
                    return zonalStats;
                }
                if (!coverageEnvelope.contains(geometryEnvelope)) {
                    geometry = JTS.toGeometry((Envelope)coverageEnvelope).intersection(geometry);
                    geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), this.dataCoverage.getCoordinateReferenceSystem());
                }
                GridSampleDimension sampleDimension = this.dataCoverage.getSampleDimension(0);
                List categories = sampleDimension.getCategories();
                ArrayList<Range> novalueRangeList = null;
                if (categories != null) {
                    for (Category category : categories) {
                        String catName = category.getName().toString();
                        if (!catName.equalsIgnoreCase("no data")) continue;
                        NumberRange range = category.getRange();
                        double min = range.getMinimum();
                        double max = category.getRange().getMaximum();
                        if (Double.isNaN(min) || Double.isNaN(max)) break;
                        Range novalueRange = new Range((Number)min, true, (Number)max, true);
                        novalueRangeList = new ArrayList<Range>();
                        novalueRangeList.add(novalueRange);
                        break;
                    }
                }
                ParameterValueGroup param = PROCESSOR.getOperation("CoverageCrop").getParameters();
                param.parameter("Source").setValue((Object)this.dataCoverage);
                param.parameter("Envelope").setValue((Object)new GeneralEnvelope((org.opengis.geometry.Envelope)geometryEnvelope));
                cropped = (GridCoverage2D)PROCESSOR.doOperation(param);
                Geometry rasterSpaceGeometry = JTS.transform(geometry, (MathTransform)w2gTransform);
                Geometry simplifiedGeometry = DouglasPeuckerSimplifier.simplify((Geometry)rasterSpaceGeometry, (double)1.0);
                AffineTransformation at = new AffineTransformation();
                at.setToTranslation(-0.5, -0.5);
                simplifiedGeometry.apply((CoordinateSequenceFilter)at);
                ROIGeometry roi = new ROIGeometry(simplifiedGeometry, false);
                Statistic[] reqStatsArr = new Statistic[]{Statistic.MAX, Statistic.MIN, Statistic.RANGE, Statistic.MEAN, Statistic.SDEV, Statistic.SUM};
                ZonalStatsOpImage zsOp = new ZonalStatsOpImage(cropped.getRenderedImage(), this.classificationRaster, null, null, reqStatsArr, new Integer[]{this.band}, (ROI)roi, null, null, null, false, novalueRangeList);
                ZonalStats zonalStats = (ZonalStats)zsOp.getProperty("ZonalStatsProperty");
                return zonalStats;
            }
            finally {
                if (cropped != null) {
                    cropped.dispose(true);
                }
            }
        }
    }

    static class RasterZonalStatisticsCollection
    extends DecoratingSimpleFeatureCollection {
        GridCoverage2D coverage;
        SimpleFeatureType targetSchema;
        int band;
        GridCoverage2D classification;

        public RasterZonalStatisticsCollection(GridCoverage2D coverage, int band, SimpleFeatureCollection zones, GridCoverage2D classification) {
            super(zones);
            this.coverage = coverage;
            this.band = band;
            this.classification = classification;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor att : ((SimpleFeatureType)zones.getSchema()).getAttributeDescriptors()) {
                tb.minOccurs(att.getMinOccurs());
                tb.maxOccurs(att.getMaxOccurs());
                tb.restrictions(att.getType().getRestrictions());
                if (att instanceof GeometryDescriptor) {
                    GeometryDescriptor gatt = (GeometryDescriptor)att;
                    tb.crs(gatt.getCoordinateReferenceSystem());
                }
                tb.add("z_" + att.getLocalName(), att.getType().getBinding());
            }
            if (classification != null) {
                tb.add("classification", Integer.class);
            }
            tb.add("count", Long.class);
            tb.add("min", Double.class);
            tb.add("max", Double.class);
            tb.add("sum", Double.class);
            tb.add("avg", Double.class);
            tb.add("stddev", Double.class);
            tb.setName(((SimpleFeatureType)zones.getSchema()).getName());
            this.targetSchema = tb.buildFeatureType();
        }

        @Override
        public SimpleFeatureType getSchema() {
            return this.targetSchema;
        }

        @Override
        public SimpleFeatureIterator features() {
            return new RasterZonalStatisticsIterator(this.delegate.features(), this.coverage, this.band, this.targetSchema, this.classification);
        }
    }
}

