/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.rlookup.RangeLookupTable;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.image.ImageWorker;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RasterProcess;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ColorUtilities;
import org.jaitools.numeric.Range;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Reclassify", description="Reclassifies a continous raster into integer values defined by a set of ranges")
public class RangeLookupProcess
implements RasterProcess {
    private static final double DEFAULT_NODATA = 0.0;

    @DescribeResult(name="reclassified", description="The reclassified raster")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="band", description="Source band to use for classification (default is 0)", min=0, defaultValue="0") Integer classificationBand, @DescribeParameter(name="ranges", description="Specifier for a value range in the format ( START ; END ).  START and END values are optional. [ and ] can also be used as brackets, to indicate inclusion of the relevant range endpoint.", collectionType=Range.class) List<Range> classificationRanges, @DescribeParameter(name="outputPixelValues", description="Value to be assigned to corresponding range", min=0) int[] outputPixelValues, @DescribeParameter(name="noData", description="Value to be assigned to pixels outside any range (defaults to 0)", min=0, defaultValue="0") Double noData, ProgressListener listener) throws ProcessException {
        RangeLookupTable lookupTable;
        int ranges;
        if (coverage == null) {
            throw new ProcessException(org.geotools.renderer.i18n.Errors.format((int)143, (Object)"coverage"));
        }
        if (classificationRanges == null) {
            throw new ProcessException(org.geotools.renderer.i18n.Errors.format((int)143, (Object)"classificationRanges"));
        }
        double nd = 0.0;
        NoDataContainer noDataProperty = org.geotools.resources.coverage.CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
        if (noData != null) {
            nd = noData;
        } else if (noDataProperty != null) {
            nd = noDataProperty.getAsSingleValue();
        }
        if (outputPixelValues != null && outputPixelValues.length > 0 && (ranges = classificationRanges.size()) != outputPixelValues.length) {
            throw new ProcessException(org.geotools.renderer.i18n.Errors.format((int)91, (Object)"outputPixelValues"));
        }
        RenderedImage sourceImage = coverage.getRenderedImage();
        ImageWorker worker = new ImageWorker(sourceImage);
        if (classificationBand != null) {
            int band = classificationBand;
            int numbands = sourceImage.getSampleModel().getNumBands();
            if (band < 0 || numbands <= band) {
                throw new ProcessException(org.geotools.renderer.i18n.Errors.format((int)58, (Object)"band", (Object)band));
            }
            if (band == 0 && numbands > 0 || band > 0) {
                worker.retainBands(new int[]{band});
            }
        }
        int size = classificationRanges.size();
        int transferType = ColorUtilities.getTransferType((int)size);
        if (JAIExt.isJAIExtOperation((String)"RLookup")) {
            lookupTable = CoverageUtilities.getRangeLookupTableJAIEXT(classificationRanges, outputPixelValues, nd, transferType);
        } else {
            switch (transferType) {
                case 0: {
                    lookupTable = CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, (byte)nd);
                    break;
                }
                case 1: {
                    lookupTable = CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, (short)nd);
                    break;
                }
                case 3: {
                    lookupTable = CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, nd);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format((int)58, (Object)"classification ranges size", (Object)size));
                }
            }
        }
        worker.setROI(org.geotools.resources.coverage.CoverageUtilities.getROIProperty((GridCoverage2D)coverage));
        worker.setBackground(new double[]{nd});
        RenderedOp indexedClassification = worker.rangeLookup((Object)lookupTable).getRenderedOperation();
        GridSampleDimension outSampleDimension = new GridSampleDimension((CharSequence)"classification", new Category[]{Category.NODATA}, null);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        HashMap<String, Object> properties = new HashMap<String, Object>(){
            {
                this.put("GC_NODATA", new NoDataContainer(0.0));
            }
        };
        org.geotools.resources.coverage.CoverageUtilities.setROIProperty((Map)properties, (ROI)worker.getROI());
        GridCoverage2D output = factory.create((CharSequence)"reclassified", (RenderedImage)indexedClassification, coverage.getGridGeometry(), new GridSampleDimension[]{outSampleDimension}, new GridCoverage[]{coverage}, (Map)properties);
        return output;
    }

    public GridCoverage2D execute(GridCoverage2D coverage, Integer classificationBand, List<Range> classificationRanges, ProgressListener listener) throws ProcessException {
        return this.execute(coverage, classificationBand, classificationRanges, null, 0.0, listener);
    }
}

