/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.image.jai.Registry;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RangeLookupProcess;
import org.geotools.process.raster.RasterProcess;
import org.jaitools.media.jai.vectorize.VectorizeDescriptor;
import org.jaitools.media.jai.vectorize.VectorizeRIF;
import org.jaitools.numeric.Range;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Polygon Extraction", description="Extracts vector polygons from a raster, based on regions which are equal or in given ranges")
public class PolygonExtractionProcess
implements RasterProcess {
    @DescribeResult(name="result", description="The extracted polygon features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Source raster") GridCoverage2D coverage, @DescribeParameter(name="band", description="Source band to use (default = 0)", min=0, defaultValue="0") Integer band, @DescribeParameter(name="insideEdges", description="Indicates whether to vectorize boundaries between adjacent regions with non-outside values", min=0) Boolean insideEdges, @DescribeParameter(name="roi", description="Geometry delineating the region of interest (in raster coordinate system)", min=0) Geometry roi, @DescribeParameter(name="nodata", description="Value to treat as NODATA (default is 0)", collectionType=Number.class, min=0) Collection<Number> noDataValues, @DescribeParameter(name="ranges", description="Specifier for a value range in the format ( START ; END ).  START and END values are optional. [ and ] can also be used as brackets, to indicate inclusion of the relevant range endpoint.", collectionType=Range.class, min=0) List<Range> classificationRanges, ProgressListener progressListener) throws ProcessException {
        boolean hasClassificationRanges;
        if (coverage == null) {
            throw new ProcessException("Invalid input, source grid coverage should be not null");
        }
        if (band == null) {
            band = 0;
        } else if (band < 0 || band >= coverage.getNumSampleDimensions()) {
            throw new ProcessException("Invalid input, invalid band number:" + band);
        }
        boolean bl = hasClassificationRanges = classificationRanges != null && classificationRanges.size() > 0;
        if (hasClassificationRanges) {
            RangeLookupProcess lookup = new RangeLookupProcess();
            coverage = lookup.execute(coverage, band, classificationRanges, progressListener);
        }
        ArrayList<Number> outsideValues = new ArrayList<Number>();
        if (noDataValues != null && !hasClassificationRanges) {
            outsideValues.addAll(noDataValues);
        } else {
            outsideValues.add(0);
        }
        AffineTransform mt2D = (AffineTransform)coverage.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        RenderedImage raster = coverage.getRenderedImage();
        ParameterBlockJAI pb = new ParameterBlockJAI("Vectorize");
        pb.setSource("source0", (Object)raster);
        if (roi != null) {
            pb.setParameter("roi", (Object)CoverageUtilities.prepareROI(roi, mt2D));
        }
        pb.setParameter("band", (Object)band);
        pb.setParameter("outsideValues", outsideValues);
        if (insideEdges != null) {
            pb.setParameter("insideEdges", (Object)insideEdges);
        }
        RenderedOp dest = JAI.create((String)"Vectorize", (ParameterBlock)pb);
        Collection prop = (Collection)dest.getProperty("vectors");
        SimpleFeatureType featureType = CoverageUtilities.createFeatureType(coverage, Polygon.class);
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        int i = 0;
        ListFeatureCollection featureCollection = new ListFeatureCollection(featureType);
        AffineTransformation jtsTransformation = new AffineTransformation(mt2D.getScaleX(), mt2D.getShearX(), mt2D.getTranslateX(), mt2D.getShearY(), mt2D.getScaleY(), mt2D.getTranslateY());
        for (Polygon polygon : prop) {
            Double value = (Double)polygon.getUserData();
            polygon.setUserData(null);
            polygon.apply((CoordinateSequenceFilter)jtsTransformation);
            builder.set("the_geom", (Object)polygon);
            builder.set("value", (Object)value);
            featureCollection.add(builder.buildFeature(String.valueOf(i++)));
        }
        return featureCollection;
    }

    static {
        Registry.registerRIF((JAI)JAI.getDefaultInstance(), (OperationDescriptor)new VectorizeDescriptor(), (RenderedImageFactory)new VectorizeRIF(), (String)"org.jaitools.media.jai");
    }
}

