/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableFactory;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROIShape;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.image.DisposeStopper;
import org.geotools.image.DrawableBitSet;
import org.geotools.image.ImageWorker;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.Range;
import org.geotools.util.Utilities;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class MarchingSquaresVectorizer {
    private static final double D_VALUE = 0.0;
    private static final int I_VALUE = 0;
    private static final double MAX_8BIT_VALUE = 255.0;
    private static final double INVALID_PIXEL_D = 255.0;
    private static final int INVALID_PIXEL_I = 255;
    private static final GeometryFactory gf = new GeometryFactory();
    private static final Geometry EMPTY_GEOMETRY = gf.createGeometryCollection(new Geometry[0]);
    private static final double MIN_AREA_TO_BE_SIMPLIFIED = 1000.0;
    private static final double DELTA = 1.0E-6;
    private static final int NO_SRID = -1;
    private static final int POSITIVE_STEP = 1;
    private static final int NEGATIVE_STEP = -1;
    private static final MathTransform TRANSLATED_TX = ProjectiveTransform.create((AffineTransform)AffineTransform.getTranslateInstance(1.0, 1.0));
    private static final Logger LOGGER = Logger.getLogger("MarchingSquaresVectorizer");
    public static final List<Range<Integer>> DEFAULT_RANGES = Collections.singletonList(new Range(Integer.class, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
    public static final double DEFAULT_SIMPLIFIER_FACTOR = 2.0;
    public static final double DEFAULT_THRESHOLD_AREA = 5.0;
    private GridCoverage2D inGeodata;
    private RenderingHints hints;
    private Stack<RenderedImage> imagesStack = new Stack();
    private ImageProperties imageProperties = new ImageProperties();
    private double simplifierFactor = 2.0;
    private double polygonArea;
    private double thresholdArea;
    private double xRes;
    private double yRes;
    private GridGeometry2D gridGeometry;
    private Geometry simplifiedFootprint;
    private Geometry footprint;
    private ROIShape roiShape;
    private RenderedImage inputRenderedImage;
    private boolean computeSimplifiedFootprint = true;
    private boolean removeCollinear = true;
    private boolean forceValid = true;
    private DrawableBitSet bitSet;
    private CoordinateReferenceSystem crs;
    private ImageLoadingType imageLoadingType;
    private List<Range<Integer>> exclusionLuminanceRanges = DEFAULT_RANGES;
    private FootprintCoordinates footprintCoordinates = FootprintCoordinates.getDefault();

    public MarchingSquaresVectorizer(GridCoverage2D inGeodata, RenderingHints hints, double thresholdArea, double simplifierFactor, ImageLoadingType imageLoadingType, List<Range<Integer>> exclusionLuminanceRanges) {
        Object l;
        RenderingHints localHints;
        this.inGeodata = inGeodata;
        this.thresholdArea = thresholdArea;
        this.simplifierFactor = simplifierFactor;
        this.exclusionLuminanceRanges = exclusionLuminanceRanges;
        RenderingHints renderingHints = localHints = hints != null ? (RenderingHints)hints.clone() : null;
        if (localHints != null && localHints.containsKey(JAI.KEY_IMAGE_LAYOUT) && (l = localHints.get(JAI.KEY_IMAGE_LAYOUT)) != null && l instanceof ImageLayout) {
            ImageLayout layout = (ImageLayout)((ImageLayout)l).clone();
            localHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        this.hints = localHints;
        this.imageLoadingType = imageLoadingType;
    }

    public MarchingSquaresVectorizer(RenderedImage ri, RenderingHints hints, double thresholdArea, ImageLoadingType imageLoadingType, List<Range<Integer>> exclusionLuminanceRanges) {
        Object l;
        RenderingHints localHints;
        this.inputRenderedImage = ri;
        this.footprintCoordinates = FootprintCoordinates.RASTER_SPACE;
        this.computeSimplifiedFootprint = false;
        this.thresholdArea = thresholdArea;
        this.exclusionLuminanceRanges = exclusionLuminanceRanges;
        RenderingHints renderingHints = localHints = hints != null ? (RenderingHints)hints.clone() : null;
        if (localHints != null && localHints.containsKey(JAI.KEY_IMAGE_LAYOUT) && (l = localHints.get(JAI.KEY_IMAGE_LAYOUT)) != null && l instanceof ImageLayout) {
            ImageLayout layout = (ImageLayout)((ImageLayout)l).clone();
            localHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        this.hints = localHints;
        this.imageLoadingType = imageLoadingType;
    }

    public MarchingSquaresVectorizer() {
    }

    public ROIShape getRoiShape() {
        return this.roiShape;
    }

    public double getPolygonArea() {
        return this.polygonArea;
    }

    public Geometry getSimplifiedFootprint() {
        return this.simplifiedFootprint;
    }

    public Geometry getFootprint() {
        return this.footprint;
    }

    public void setRemoveCollinear(boolean removeCollinear) {
        this.removeCollinear = removeCollinear;
    }

    public void setForceValid(boolean forceValid) {
        this.forceValid = forceValid;
    }

    public void setComputeSimplifiedFootprint(boolean computeSimplifiedFootprint) {
        this.computeSimplifiedFootprint = computeSimplifiedFootprint;
    }

    public void setImageLoadingType(ImageLoadingType imageLoadingType) {
        this.imageLoadingType = imageLoadingType;
    }

    public ImageLoadingType getImageLoadingType() {
        return this.imageLoadingType;
    }

    public void process() throws Exception {
        int sampleDataType = -1;
        RandomIter iter = null;
        RenderedImage inputRI = null;
        try {
            inputRI = this.inGeodata != null ? this.inGeodata.getRenderedImage() : this.inputRenderedImage;
            inputRI = new DisposeStopper(inputRI);
            ImageLayout layout = new ImageLayout(inputRI);
            RenderingHints localHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            if (this.hints != null) {
                localHints.add(this.hints);
            }
            inputRI = this.computeLuminance(inputRI, localHints);
            inputRI = this.prepareMaskingLookup(inputRI, localHints);
            this.imagesStack.push(inputRI);
            iter = RandomIterFactory.create((RenderedImage)inputRI, null);
            if (this.inGeodata != null) {
                HashMap<String, Double> regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inGeodata);
                this.imageProperties.init(regionMap, inputRI);
                this.xRes = regionMap.get("XRES");
                this.yRes = regionMap.get("YRES");
                this.gridGeometry = this.inGeodata.getGridGeometry();
                this.crs = this.inGeodata.getCoordinateReferenceSystem2D();
            } else {
                this.imageProperties.init(inputRI);
            }
            sampleDataType = inputRI.getSampleModel().getDataType();
            this.bitSet = new DrawableBitSet(this.imageProperties.width, this.imageProperties.height);
            List<Polygon> geometriesList = new ArrayList<Polygon>();
            ScanInfo scanInfo = new ScanInfo();
            this.identifyGeometries(iter, sampleDataType, geometriesList, scanInfo);
            scanInfo.isFullyInvalid(geometriesList, inputRI, localHints);
            geometriesList = this.validateGeometries(geometriesList);
            if (this.noGeometries(geometriesList, scanInfo.fullyInvalid)) {
                return;
            }
            MathTransform transform = null;
            if (this.footprintCoordinates == FootprintCoordinates.MODEL_SPACE) {
                transform = this.gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER);
                LinearTransform translation = ProjectiveTransform.createTranslation((int)2, (double)1.0);
                transform = ConcatenatedTransform.create((MathTransform)translation, (MathTransform)transform);
            }
            double area = 0.0;
            int polygonIndex = 0;
            int index = 0;
            for (Polygon polygon : geometriesList) {
                double polygonArea = polygon.getArea();
                if (polygonArea > area) {
                    polygonIndex = index;
                    area = polygonArea;
                }
                ++index;
            }
            this.computeFootprint(geometriesList, transform);
            this.computeSimplifiedFootprint(geometriesList, transform, polygonIndex, area);
        }
        catch (Exception ex) {
            ImageAnalysisResultThdLocal.set(ex);
            throw ex;
        }
        finally {
            if (iter != null) {
                iter.done();
                iter = null;
            }
        }
    }

    private RenderedImage computeLuminance(RenderedImage inputRI, RenderingHints localHints) {
        int numBands = inputRI.getSampleModel().getNumBands();
        int tr = inputRI.getColorModel().getTransparency();
        if (numBands != 1) {
            ImageWorker worker = new ImageWorker(inputRI).setRenderingHints(localHints);
            if (numBands == 3) {
                worker.bandCombine(ImageUtilities.RGB_TO_GRAY_MATRIX);
            } else {
                double fillValue = tr == 1 ? 1.0 / (double)numBands : 1.0 / (double)(numBands - 1);
                double[][] matrix = new double[1][numBands + 1];
                for (int i = 0; i < numBands; ++i) {
                    matrix[0][i] = fillValue;
                }
                worker.bandCombine(matrix);
            }
            inputRI = worker.getRenderedImage();
            this.imagesStack.push(worker.getRenderedImage());
            numBands = inputRI.getSampleModel().getNumBands();
            assert (numBands == 1);
        }
        ImageLayout layout2 = (ImageLayout)localHints.get(JAI.KEY_IMAGE_LAYOUT);
        layout2.setColorModel((ColorModel)ColorUtilities.GRAY_CM);
        layout2.setSampleModel(ColorUtilities.GRAY_CM.createCompatibleSampleModel(inputRI.getTileWidth(), inputRI.getTileHeight()));
        return inputRI;
    }

    private boolean noGeometries(List<Polygon> geometriesList, boolean isAllZeros) {
        if (geometriesList.size() == 0) {
            if (isAllZeros) {
                this.footprint = EMPTY_GEOMETRY;
                this.simplifiedFootprint = EMPTY_GEOMETRY;
            } else {
                this.simplifiedFootprint = null;
                this.footprint = null;
            }
            return true;
        }
        return false;
    }

    private List<Polygon> validateGeometries(List<Polygon> geometriesList) {
        if (this.forceValid && geometriesList.size() > 0) {
            ArrayList<Polygon> validated = new ArrayList<Polygon>(geometriesList.size());
            for (int i = 0; i < geometriesList.size(); ++i) {
                Polygon polygon = geometriesList.get(i);
                if (!polygon.isValid()) {
                    List<Polygon> validPolygons = JTS.makeValid(polygon, true);
                    validated.addAll(validPolygons);
                    continue;
                }
                validated.add(polygon);
            }
            geometriesList = validated;
        }
        return geometriesList;
    }

    private void computeFootprint(List<Polygon> geometriesList, MathTransform transform) throws MismatchedDimensionException, TransformException, FactoryException {
        Polygon[] polArray = new Polygon[geometriesList.size()];
        Polygon[] polygons = geometriesList.toArray(polArray);
        MultiPolygon innerGeometry = new MultiPolygon(polygons, gf);
        if (this.footprintCoordinates == FootprintCoordinates.MODEL_SPACE) {
            this.footprint = JTS.transform((Geometry)innerGeometry, transform);
        } else {
            this.footprint = innerGeometry;
            innerGeometry.setSRID(-1);
        }
        if (!innerGeometry.isEmpty()) {
            LiteShape2 shape = new LiteShape2((Geometry)innerGeometry, TRANSLATED_TX, null, false);
            this.roiShape = new ROIShape((Shape)shape);
        }
    }

    private void computeSimplifiedFootprint(List<Polygon> geometriesList, MathTransform transform, int polygonIndex, double area) throws MismatchedDimensionException, TransformException {
        if (this.computeSimplifiedFootprint && !geometriesList.isEmpty()) {
            Geometry simplifiedFootprintGeometry;
            block10: {
                simplifiedFootprintGeometry = (Geometry)geometriesList.get(polygonIndex);
                Geometry finalSimplifiedFootprint = null;
                if (this.footprintCoordinates == FootprintCoordinates.MODEL_SPACE) {
                    finalSimplifiedFootprint = JTS.transform(simplifiedFootprintGeometry, transform);
                } else {
                    simplifiedFootprintGeometry.setSRID(-1);
                    finalSimplifiedFootprint = simplifiedFootprintGeometry;
                }
                this.polygonArea = finalSimplifiedFootprint.getArea();
                double tolerance = Math.max(this.xRes, this.yRes) * this.simplifierFactor;
                Geometry geometry = simplifiedFootprintGeometry = area > 1000.0 ? TopologyPreservingSimplifier.simplify((Geometry)finalSimplifiedFootprint, (double)tolerance) : finalSimplifiedFootprint;
                if (simplifiedFootprintGeometry == null) {
                    throw new IllegalStateException("No simplified Footprint can be computed");
                }
                try {
                    Integer srid = CRS.lookupEpsgCode((CoordinateReferenceSystem)this.crs, (boolean)false);
                    if (this.footprintCoordinates == FootprintCoordinates.MODEL_SPACE) {
                        if (srid != null) {
                            simplifiedFootprintGeometry.setSRID(srid.intValue());
                        }
                    } else {
                        simplifiedFootprintGeometry.setSRID(-1);
                    }
                }
                catch (FactoryException fe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block10;
                    LOGGER.fine("Unable to lookup an EPSG code for the provided CRS");
                }
            }
            this.simplifiedFootprint = simplifiedFootprintGeometry;
        } else {
            this.simplifiedFootprint = null;
        }
    }

    private void identifyGeometries(RandomIter iter, int sampleDataType, List<Polygon> geometriesList, ScanInfo scanInfo) throws TransformException {
        if (sampleDataType == 5) {
            scanInfo.fullyCovered = this.checkFullyCovered(iter, 0.0, geometriesList);
        } else if (sampleDataType == 0) {
            scanInfo.fullyCovered = this.checkFullyCovered(iter, 0, geometriesList);
        }
        boolean firstRef = true;
        java.awt.Polygon awtPolygon = new java.awt.Polygon();
        if (!scanInfo.fullyCovered) {
            int minX = this.imageProperties.minX;
            int minY = this.imageProperties.minY;
            int maxX = this.imageProperties.maxX;
            int maxY = this.imageProperties.maxY;
            int minTileY = this.imageProperties.minTileY;
            int minTileX = this.imageProperties.minTileX;
            int maxTileY = this.imageProperties.maxTileY;
            int maxTileX = this.imageProperties.maxTileX;
            int tileWidth = this.imageProperties.tileWidth;
            int tileHeight = this.imageProperties.tileHeight;
            if (sampleDataType == 5) {
                for (int tileY = minTileY; tileY <= maxTileY; ++tileY) {
                    for (int tileX = minTileX; tileX <= maxTileX; ++tileX) {
                        for (int trow = 0; trow < tileHeight; ++trow) {
                            int row = tileY * tileHeight + trow;
                            if (row < minY || row > maxY) continue;
                            for (int tcol = 0; tcol < tileWidth; ++tcol) {
                                int col = tileX * tileWidth + tcol;
                                if (col < minX || col > maxX) continue;
                                double value = iter.getSampleDouble(col, row, 0);
                                if (this.bitSet.get(col - minX, row - minY) || Double.isNaN(value) || !MarchingSquaresVectorizer.areEqual(value, 0.0)) continue;
                                Polygon polygon = this.identifyPerimeter(iter, col, row, awtPolygon, sampleDataType, scanInfo);
                                if (polygon != null) {
                                    if (this.removeCollinear) {
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.fine("Removing collinear points");
                                        }
                                        polygon = (Polygon)JTS.removeCollinearVertices((Geometry)polygon);
                                    }
                                    this.bitSet.set((Geometry)polygon);
                                    geometriesList.add(polygon);
                                    continue;
                                }
                                if (!scanInfo.firstFound || !firstRef) continue;
                                scanInfo.refColumn = col;
                                scanInfo.refRow = row;
                                firstRef = false;
                            }
                        }
                    }
                }
            } else if (sampleDataType == 0) {
                for (int tileY = minTileY; tileY <= maxTileY; ++tileY) {
                    for (int tileX = minTileX; tileX <= maxTileX; ++tileX) {
                        for (int trow = 0; trow < tileHeight; ++trow) {
                            int row = tileY * tileHeight + trow;
                            if (row < minY || row > maxY) continue;
                            for (int tcol = 0; tcol < tileWidth; ++tcol) {
                                int col = tileX * tileWidth + tcol;
                                if (col < minX || col > maxX) continue;
                                int value = iter.getSample(col, row, 0);
                                if (this.bitSet.get(col - minX, row - minY) || value != 0) continue;
                                Polygon polygon = this.identifyPerimeter(iter, col, row, awtPolygon, sampleDataType, scanInfo);
                                if (polygon != null) {
                                    if (this.removeCollinear) {
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.fine("Removing collinear points");
                                        }
                                        polygon = (Polygon)JTS.removeCollinearVertices((Geometry)polygon);
                                    }
                                    geometriesList.add(polygon);
                                    this.bitSet.set((Geometry)polygon);
                                    continue;
                                }
                                if (!scanInfo.firstFound || !firstRef) continue;
                                scanInfo.refColumn = col;
                                scanInfo.refRow = row;
                                firstRef = false;
                            }
                        }
                    }
                }
            }
        }
        if (!scanInfo.fullyCovered && geometriesList.isEmpty() && scanInfo.refColumn != Integer.MIN_VALUE && scanInfo.refColumn != Integer.MAX_VALUE) {
            scanInfo.takeFirst = true;
            Polygon polygon = this.identifyPerimeter(iter, scanInfo.refColumn, scanInfo.refRow, awtPolygon, sampleDataType, scanInfo);
            geometriesList.add(polygon);
        }
    }

    private RenderedImage prepareMaskingLookup(RenderedImage inputRI, RenderingHints localHints) {
        int dataType = inputRI.getSampleModel().getDataType();
        double scale = 1.0;
        double offset = 0.0;
        ImageWorker worker = new ImageWorker(inputRI);
        worker.setRenderingHints(localHints);
        if (dataType != 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rescaling dynamic to fit BYTE datatype from " + ImageUtilities.getDatabufferTypeName((int)dataType));
            }
            switch (dataType) {
                case 1: {
                    inputRI = worker.lookup(this.createLookupTableUShort(this.exclusionLuminanceRanges, dataType)).getRenderedImage();
                    break;
                }
                case 2: {
                    scale = 0.007782219916379284;
                    offset = 127.50194552529183;
                    worker.rescale(new double[]{scale}, new double[]{offset});
                    this.imagesStack.push(worker.getRenderedImage());
                    inputRI = worker.lookup(this.createLookupTableByte(this.exclusionLuminanceRanges, dataType)).getRenderedImage();
                    break;
                }
                case 3: {
                    scale = 1.1874362831876782E-7;
                    offset = -5.4760833024E11;
                    worker.rescale(new double[]{scale}, new double[]{offset});
                    this.imagesStack.push(worker.getRenderedImage());
                    inputRI = worker.lookup(this.createLookupTableByte(this.exclusionLuminanceRanges, dataType)).getRenderedImage();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Wrong data type:" + dataType);
                }
            }
            assert (inputRI.getSampleModel().getDataType() == 0);
        } else {
            inputRI = worker.lookup(this.createLookupTableByte(this.exclusionLuminanceRanges, dataType)).getRenderedImage();
        }
        return inputRI;
    }

    private boolean checkFullyCovered(RandomIter iter, int refValue, List<Polygon> geometriesList) {
        int[] xvals;
        int[] yvals;
        for (int y : yvals = new int[]{this.imageProperties.minY, this.imageProperties.maxY}) {
            for (int x = this.imageProperties.minX; x <= this.imageProperties.maxX; ++x) {
                int value = iter.getSample(x, y, 0);
                if (value == refValue) continue;
                return false;
            }
        }
        for (int x : xvals = new int[]{this.imageProperties.minX, this.imageProperties.maxX}) {
            for (int y = this.imageProperties.minY; y <= this.imageProperties.maxY; ++y) {
                int value = iter.getSample(x, y, 0);
                if (value == refValue) continue;
                return false;
            }
        }
        this.addFullAreaPolygon(geometriesList);
        return true;
    }

    private boolean checkFullyCovered(RandomIter iter, double refValue, List<Polygon> geometriesList) {
        double value;
        for (int y = this.imageProperties.minY; y <= this.imageProperties.maxY; y += this.imageProperties.maxY - this.imageProperties.minY) {
            for (int x = this.imageProperties.minX; x <= this.imageProperties.maxX; ++x) {
                value = iter.getSample(x, y, 0);
                if (value == refValue) continue;
                return false;
            }
        }
        for (int x = this.imageProperties.minX; x <= this.imageProperties.maxX; x += this.imageProperties.maxX - this.imageProperties.minX) {
            for (int y = this.imageProperties.minY; y <= this.imageProperties.maxY; y += this.imageProperties.maxY - this.imageProperties.minY) {
                value = iter.getSample(x, y, 0);
                if (value == refValue) continue;
                return false;
            }
        }
        this.addFullAreaPolygon(geometriesList);
        return true;
    }

    private void addFullAreaPolygon(List<Polygon> geometriesList) {
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate((double)(this.imageProperties.minX - 1), (double)(this.imageProperties.minY - 1)), new Coordinate((double)this.imageProperties.maxX, (double)(this.imageProperties.minY - 1)), new Coordinate((double)this.imageProperties.maxX, (double)this.imageProperties.maxY), new Coordinate((double)(this.imageProperties.minX - 1), (double)this.imageProperties.maxY), new Coordinate((double)(this.imageProperties.minX - 1), (double)(this.imageProperties.minY - 1))};
        LinearRing linearRing = gf.createLinearRing(coordinateArray);
        Polygon polygon = gf.createPolygon(linearRing, null);
        geometriesList.add(polygon);
    }

    private Polygon identifyPerimeter(RandomIter iter, int initialX, int initialY, java.awt.Polygon awtPolygon, int sampleDataType, ScanInfo scanInfo) throws TransformException {
        if (initialX < this.imageProperties.minX || initialX > this.imageProperties.maxX || initialY < this.imageProperties.minY || initialY > this.imageProperties.maxY) {
            throw new IllegalArgumentException("Coordinate outside the bounds.");
        }
        int initialValue = this.value(iter, initialX, initialY, sampleDataType, false);
        if (initialValue == 0) {
            throw new IllegalArgumentException(String.format("Supplied initial coordinates (%d, %d) do not lie on a perimeter.", initialX, initialY));
        }
        if (initialValue == 15) {
            return null;
        }
        Point2D.Double worldPosition = new Point2D.Double(initialX - 1, initialY - 1);
        Coordinate startCoordinate = new Coordinate(((Point2D)worldPosition).getX(), ((Point2D)worldPosition).getY());
        ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>(200);
        int x = initialX;
        int y = initialY;
        awtPolygon.reset();
        awtPolygon.addPoint(x, y);
        boolean previousWentNorth = false;
        boolean previousWentEast = true;
        int v = this.value(iter, x, y, sampleDataType, true);
        do {
            int dx = 0;
            int dy = 0;
            switch (v) {
                case 1: {
                    dy = -1;
                    previousWentNorth = true;
                    break;
                }
                case 2: {
                    dx = 1;
                    previousWentEast = true;
                    break;
                }
                case 3: {
                    dx = 1;
                    previousWentEast = true;
                    break;
                }
                case 4: {
                    dx = -1;
                    previousWentEast = false;
                    break;
                }
                case 5: {
                    dy = -1;
                    previousWentNorth = true;
                    break;
                }
                case 6: {
                    if (!previousWentNorth) {
                        dx = -1;
                        previousWentEast = false;
                        break;
                    }
                    dx = 1;
                    previousWentEast = true;
                    break;
                }
                case 7: {
                    dx = 1;
                    previousWentEast = true;
                    break;
                }
                case 8: {
                    dy = 1;
                    previousWentNorth = false;
                    break;
                }
                case 9: {
                    if (previousWentEast) {
                        if (this.isLowerCorner(iter, x, y, sampleDataType)) {
                            dy = 1;
                            previousWentNorth = false;
                            break;
                        }
                        dy = -1;
                        previousWentNorth = true;
                        break;
                    }
                    if (this.isLowerCorner(iter, x, y, sampleDataType)) {
                        dy = -1;
                        previousWentNorth = true;
                        break;
                    }
                    dy = 1;
                    previousWentNorth = false;
                    break;
                }
                case 10: {
                    dy = 1;
                    previousWentNorth = false;
                    break;
                }
                case 11: {
                    dy = 1;
                    previousWentNorth = false;
                    break;
                }
                case 12: {
                    dx = -1;
                    previousWentEast = false;
                    break;
                }
                case 13: {
                    dy = -1;
                    previousWentNorth = true;
                    break;
                }
                case 14: {
                    dx = -1;
                    previousWentEast = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal state: " + v);
                }
            }
            Coordinate direction = new Coordinate((double)(x - 1), (double)(y - 1));
            coordinateList.add(direction);
            v = this.value(iter, x += dx, y += dy, sampleDataType, true);
            awtPolygon.addPoint(x, y);
        } while (x != initialX || y != initialY);
        double polygonArea = MarchingSquaresVectorizer.getPolygonArea(awtPolygon.xpoints, awtPolygon.ypoints, awtPolygon.npoints - 1);
        if (polygonArea < this.thresholdArea) {
            if (!scanInfo.firstFound) {
                scanInfo.firstFound = true;
            }
            if (!scanInfo.takeFirst) {
                return null;
            }
        }
        coordinateList.add(startCoordinate);
        Coordinate[] coordinateArray = coordinateList.toArray(new Coordinate[coordinateList.size()]);
        LinearRing linearRing = gf.createLinearRing(coordinateArray);
        Polygon polygon = gf.createPolygon(linearRing, null);
        return polygon;
    }

    private boolean isLowerCorner(RandomIter iter, int x, int y, int sampleDataType) {
        return this.value(iter, x + 1, y, sampleDataType, false) == 4 && this.value(iter, x, y + 1, sampleDataType, false) == 2 && this.value(iter, x + 1, y + 1, sampleDataType, false) == 1;
    }

    private int value(RandomIter iter, int x, int y, int dataType, boolean forceSetting) {
        int sum = 0;
        if (this.isSet(iter, x - 1, y - 1, dataType, forceSetting)) {
            sum |= 1;
        }
        if (this.isSet(iter, x, y - 1, dataType, forceSetting)) {
            sum |= 2;
        }
        if (this.isSet(iter, x - 1, y, dataType, forceSetting)) {
            sum |= 4;
        }
        if (this.isSet(iter, x, y, dataType, forceSetting)) {
            sum |= 8;
        }
        if (sum == 0 && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("x " + x + " y" + y);
        }
        return sum;
    }

    private boolean isSet(RandomIter iter, int x, int y, int dataType, boolean forceSetting) {
        boolean isOutsideGrid;
        boolean bl = isOutsideGrid = x < this.imageProperties.minX || x > this.imageProperties.maxX || y < this.imageProperties.minY || y > this.imageProperties.maxY;
        if (isOutsideGrid) {
            return false;
        }
        if (dataType == 5) {
            double value = iter.getSampleDouble(x, y, 0);
            if (!Double.isNaN(value)) {
                if (forceSetting || x == this.imageProperties.maxX) {
                    this.bitSet.set(x - this.imageProperties.minX, y - this.imageProperties.minY);
                }
            } else {
                return false;
            }
            if (MarchingSquaresVectorizer.areEqual(value, 0.0)) {
                return true;
            }
        } else {
            int value = iter.getSample(x, y, 0);
            if (forceSetting || x == this.imageProperties.maxX) {
                this.bitSet.set(x - this.imageProperties.minX, y - this.imageProperties.minY);
            }
            if (value == 0) {
                return true;
            }
        }
        return false;
    }

    public static final boolean areEqual(double value, double pValue) {
        return Math.abs(value - pValue) < 1.0E-6;
    }

    public void dispose() {
        this.bitSet = null;
        while (!this.imagesStack.isEmpty()) {
            RenderedImage removeMe = this.imagesStack.pop();
            if (removeMe == null) continue;
            ImageUtilities.disposeImage((RenderedImage)removeMe);
        }
    }

    public static double getPolygonArea(List<Coordinate> coordinateList) {
        Utilities.ensureNonNull((String)"coordinateList", coordinateList);
        int N = coordinateList.size() - 1;
        double area = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            Coordinate cj = coordinateList.get(j);
            Coordinate ci = coordinateList.get(i);
            area += ci.x * cj.y;
            area -= ci.y * cj.x;
        }
        return (area /= 2.0) < 0.0 ? -area : area;
    }

    public static double getPolygonArea(int[] x, int[] y, int N) {
        double area = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            area += (double)(x[i] * y[j]);
            area -= (double)(y[i] * x[j]);
        }
        return (area /= 2.0) < 0.0 ? -area : area;
    }

    public static Polygon createSimplePolygon(Coordinate[] coords) {
        return gf.createPolygon(gf.createLinearRing(coords), null);
    }

    private LookupTable createLookupTableByte(List<Range<Integer>> exclusionValues, int dataType) {
        byte[] b = new byte[256];
        Arrays.fill(b, (byte)0);
        for (Range<Integer> exclusionValue : exclusionValues) {
            int minValue = (Integer)exclusionValue.getMinValue();
            int maxValue = (Integer)exclusionValue.getMaxValue();
            for (int i = minValue; i <= maxValue; ++i) {
                b[i] = -1;
            }
        }
        return LookupTableFactory.create((byte[])b, (int)dataType);
    }

    private LookupTable createLookupTableUShort(List<Range<Integer>> exclusionValues, int dataType) {
        byte[] bUShort = new byte[65536];
        Arrays.fill(bUShort, (byte)0);
        for (Range<Integer> exclusionValue : exclusionValues) {
            int minValue = (Integer)exclusionValue.getMinValue();
            int maxValue = (Integer)exclusionValue.getMaxValue();
            for (int i = minValue; i <= maxValue; ++i) {
                bUShort[i] = -1;
            }
        }
        return LookupTableFactory.create((byte[])bUShort, (int)dataType);
    }

    public static class ImageAnalysisResultThdLocal {
        private static final InheritableThreadLocal<Exception> tl = new InheritableThreadLocal<Exception>(){

            @Override
            protected Exception initialValue() {
                return null;
            }
        };

        public static Exception get() {
            return (Exception)tl.get();
        }

        public static void set(Exception ex) {
            tl.set(ex);
        }

        public static void clear() {
            tl.remove();
        }

        private ImageAnalysisResultThdLocal() {
        }
    }

    static class ScanInfo {
        boolean takeFirst = false;
        boolean firstFound = false;
        int refColumn = Integer.MIN_VALUE;
        int refRow = Integer.MIN_VALUE;
        boolean fullyCovered = false;
        boolean fullyInvalid = false;

        ScanInfo() {
        }

        private void isFullyInvalid(List<Polygon> geometriesList, RenderedImage inputRI, RenderingHints localHints) throws Exception {
            if (geometriesList.size() == 0) {
                ImageWorker w = new ImageWorker(inputRI);
                double[] extrema = w.getMinimums();
                if (!MarchingSquaresVectorizer.areEqual(extrema[0], 255.0)) {
                    Exception ex = new Exception("Unknown MarchingSquares processing error");
                    ImageAnalysisResultThdLocal.set(ex);
                    throw ex;
                }
                this.fullyInvalid = true;
            }
        }
    }

    static class ImageProperties {
        int height;
        int width;
        int minX;
        int minY;
        int maxX;
        int maxY;
        int minTileX;
        int minTileY;
        int maxTileX;
        int maxTileY;
        int tileWidth;
        int tileHeight;

        ImageProperties() {
        }

        public void init(HashMap<String, Double> regionMap, RenderedImage inputRI) {
            this.height = regionMap.get("ROWS").intValue();
            this.width = regionMap.get("COLS").intValue();
            this.minX = regionMap.get("MINX").intValue();
            this.minY = regionMap.get("MINY").intValue();
            this.maxX = this.minX + this.width - 1;
            this.maxY = this.minY + this.height - 1;
            this.initTiling(inputRI);
        }

        private void initTiling(RenderedImage inputRI) {
            this.tileWidth = Math.min(inputRI.getTileWidth(), this.width);
            this.tileHeight = Math.min(inputRI.getTileHeight(), this.height);
            this.minTileX = this.minX / this.tileWidth - (this.minX < 0 ? (-this.minX % this.tileWidth > 0 ? 1 : 0) : 0);
            this.minTileY = this.minY / this.tileHeight - (this.minY < 0 ? (-this.minY % this.tileHeight > 0 ? 1 : 0) : 0);
            this.maxTileX = this.maxX / this.tileWidth - (this.maxX < 0 ? (-this.maxX % this.tileWidth > 0 ? 1 : 0) : 0);
            this.maxTileY = this.maxY / this.tileHeight - (this.maxY < 0 ? (-this.maxY % this.tileHeight > 0 ? 1 : 0) : 0);
        }

        public void init(RenderedImage inputRI) {
            this.height = inputRI.getHeight();
            this.width = inputRI.getWidth();
            this.minX = inputRI.getMinX();
            this.minY = inputRI.getMinY();
            this.maxX = this.minX + this.width - 1;
            this.maxY = this.minY + this.height - 1;
            this.initTiling(inputRI);
        }
    }

    public static enum ImageLoadingType {
        IMMEDIATE,
        DEFERRED;


        public static ImageLoadingType getDefault() {
            return IMMEDIATE;
        }
    }

    public static enum FootprintCoordinates {
        RASTER_SPACE,
        MODEL_SPACE;


        public static FootprintCoordinates getDefault() {
            return MODEL_SPACE;
        }
    }
}

