/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Collection;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.BaseCoverageAlgebraProcess;
import org.geotools.process.raster.RasterProcess;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@DescribeProcess(title="Merge Coverages", description="Returns a raster generated by the merge of the input raster bands. Source rasters must have the same CRS.")
public class BandMergeProcess
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="result", description="Merged Rasters")
    public GridCoverage2D execute(@DescribeParameter(name="coverages", description="Coverage List", min=1, collectionType=GridCoverage2D.class) Collection<GridCoverage2D> coverages, @DescribeParameter(name="roi", description="Geometry to use as ROI", min=0) Geometry roi, @DescribeParameter(name="transformChoice", description="Choice on which Coverage G2W transform to use", min=0) String transformChoice, @DescribeParameter(name="index", description="Index used by the transformChoice parameter", min=0) Integer index) throws ProcessException {
        BaseCoverageAlgebraProcess.checkCompatibleCoveragesForMerge(coverages);
        ParameterValueGroup param = PROCESSOR.getOperation("BandMerge").getParameters();
        Geometry geo = null;
        if (roi != null) {
            geo = roi;
            Object crsGeo = geo.getUserData();
            if (crsGeo != null && crsGeo instanceof CoordinateReferenceSystem) {
                CoordinateReferenceSystem geoCRS = (CoordinateReferenceSystem)crsGeo;
                GridCoverage2D cov = coverages.iterator().next();
                BaseCoverageAlgebraProcess.checkCompatibleCRS(geoCRS, cov.getCoordinateReferenceSystem());
                param.parameter("geometry").setValue((Object)geo);
            } else {
                param.parameter("geometry").setValue((Object)geo);
            }
        }
        param.parameter("sources").setValue(coverages);
        if (transformChoice != null && !transformChoice.isEmpty()) {
            param.parameter("transform_choice").setValue((Object)transformChoice);
        }
        if (transformChoice != null && !transformChoice.isEmpty()) {
            param.parameter("coverage_idx").setValue((Object)index);
        }
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }
}

