/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.browser.FileBreadcrumbs;
import org.geoserver.web.wicket.browser.FileDataView;
import org.geoserver.web.wicket.browser.FileProvider;

public class GeoServerFileChooser
extends Panel {
    static Boolean HIDE_FS = null;
    static File USER_HOME;
    FileBreadcrumbs breadcrumbs;
    FileDataView fileTable;
    boolean hideFileSystem = false;
    IModel file;

    public GeoServerFileChooser(String id, IModel file) {
        this(id, file, HIDE_FS);
    }

    public GeoServerFileChooser(String id, IModel file, boolean hideFileSystem) {
        super(id, file);
        File relativeToDataDir;
        File selection;
        this.file = file;
        this.hideFileSystem = hideFileSystem;
        ArrayList<File> roots = new ArrayList<File>();
        if (!hideFileSystem) {
            roots.addAll(Arrays.asList(File.listRoots()));
        }
        Collections.sort(roots);
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        File dataDirectory = loader.getBaseDirectory();
        roots.add(0, dataDirectory);
        if (!hideFileSystem && USER_HOME != null) {
            roots.add(1, USER_HOME);
        }
        if ((selection = (File)file.getObject()) != null && (relativeToDataDir = loader.url(selection.getPath())) != null) {
            selection = relativeToDataDir;
        }
        File selectionRoot = null;
        if (selection != null && selection.exists()) {
            for (File root : roots) {
                if (!this.isSubfile(root, selection.getAbsoluteFile())) continue;
                selectionRoot = root;
                break;
            }
            if (selectionRoot == null) {
                selectionRoot = dataDirectory;
                file = new Model((Serializable)selectionRoot);
            } else {
                file = !selection.isDirectory() ? new Model((Serializable)selection.getParentFile()) : new Model((Serializable)selection);
            }
        } else {
            selectionRoot = dataDirectory;
            file = new Model((Serializable)selectionRoot);
        }
        this.file = file;
        this.setDefaultModel(file);
        final DropDownChoice choice = new DropDownChoice("roots", (IModel)new Model((Serializable)selectionRoot), (IModel)new Model(roots), (IChoiceRenderer)new FileRootsRenderer());
        choice.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                File selection = (File)choice.getModelObject();
                GeoServerFileChooser.this.breadcrumbs.setRootFile(selection);
                GeoServerFileChooser.this.updateFileBrowser(selection, target);
            }
        }});
        choice.setOutputMarkupId(true);
        this.add(new Component[]{choice});
        this.breadcrumbs = new FileBreadcrumbs("breadcrumbs", (IModel)new Model((Serializable)selectionRoot), file){

            @Override
            protected void pathItemClicked(File file, AjaxRequestTarget target) {
                GeoServerFileChooser.this.updateFileBrowser(file, target);
            }
        };
        this.breadcrumbs.setOutputMarkupId(true);
        this.add(new Component[]{this.breadcrumbs});
        this.fileTable = new FileDataView("fileTable", new FileProvider(file)){

            @Override
            protected void linkNameClicked(File file, AjaxRequestTarget target) {
                GeoServerFileChooser.this.updateFileBrowser(file, target);
            }
        };
        this.fileTable.setOutputMarkupId(true);
        this.add(new Component[]{this.fileTable});
    }

    void updateFileBrowser(File file, AjaxRequestTarget target) {
        if (file.isDirectory()) {
            this.directoryClicked(file, target);
        } else if (file.isFile()) {
            this.fileClicked(file, target);
        }
    }

    protected void fileClicked(File file, AjaxRequestTarget target) {
    }

    protected void directoryClicked(File file, AjaxRequestTarget target) {
        this.file.setObject((Object)file);
        this.fileTable.getProvider().setDirectory((IModel)new Model((Serializable)file));
        this.breadcrumbs.setSelection(file);
        target.addComponent((Component)this.fileTable);
        target.addComponent((Component)this.breadcrumbs);
    }

    private boolean isSubfile(File root, File selection) {
        if (selection == null || "".equals(selection.getPath())) {
            return false;
        }
        if (selection.equals(root)) {
            return true;
        }
        return this.isSubfile(root, selection.getParentFile());
    }

    public void setFilter(IModel<? extends FileFilter> fileFilter) {
        this.fileTable.provider.setFileFilter(fileFilter);
    }

    public void setFileTableHeight(String height) {
        this.fileTable.setTableHeight(height);
    }

    static {
        HIDE_FS = Boolean.valueOf(GeoServerExtensions.getProperty((String)"GEOSERVER_FILEBROWSER_HIDEFS"));
        USER_HOME = null;
        try {
            File hf = null;
            String home = System.getProperty("user.home");
            if (home != null) {
                hf = new File(home);
            }
            if (hf != null && hf.exists()) {
                USER_HOME = hf;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class FileRootsRenderer
    implements IChoiceRenderer {
        FileRootsRenderer() {
        }

        public Object getDisplayValue(Object o) {
            File f = (File)o;
            if (f == USER_HOME) {
                return new ParamResourceModel("userHome", (Component)GeoServerFileChooser.this, new Object[0]).getString();
            }
            GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            if (f.equals(loader.getBaseDirectory())) {
                return new ParamResourceModel("dataDirectory", (Component)GeoServerFileChooser.this, new Object[0]).getString();
            }
            try {
                String displayName = FileSystemView.getFileSystemView().getSystemDisplayName(f);
                if (displayName != null && displayName.length() > 0) {
                    return displayName;
                }
                return FilenameUtils.getPrefix((String)f.getAbsolutePath());
            }
            catch (Exception exception) {
                return f.getName();
            }
        }

        public String getIdValue(Object o, int count) {
            File f = (File)o;
            return "" + count;
        }
    }
}

