/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;

public class UpDownPanel<T>
extends Panel {
    T entry;
    private ImageAjaxLink upLink;
    private ImageAjaxLink downLink;
    private Component container;

    public UpDownPanel(String id, final T entry, final List<T> items, Component container, final StringResourceModel upTitle, final StringResourceModel downTitle) {
        super(id);
        this.entry = entry;
        this.setOutputMarkupId(true);
        this.container = container;
        this.upLink = new ImageAjaxLink("up", new ResourceReference(((Object)((Object)this)).getClass(), "../img/icons/silk/arrow_up.png")){

            @Override
            protected void onClick(AjaxRequestTarget target) {
                int index = items.indexOf(UpDownPanel.this.entry);
                items.remove(index);
                items.add(Math.max(0, index - 1), UpDownPanel.this.entry);
                target.addComponent(UpDownPanel.this.container);
                target.addComponent((Component)this);
                target.addComponent((Component)UpDownPanel.this.downLink);
                target.addComponent((Component)UpDownPanel.this.upLink);
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.put("title", (CharSequence)upTitle.getString());
                if (items.indexOf(entry) == 0) {
                    tag.put("style", (CharSequence)"visibility:hidden");
                } else {
                    tag.put("style", (CharSequence)"visibility:visible");
                }
            }
        };
        this.upLink.getImage().add(new IBehavior[]{new AttributeModifier("alt", true, (IModel)new ParamResourceModel("up", (Component)this.upLink, new Object[0]))});
        this.upLink.setOutputMarkupId(true);
        this.add(new Component[]{this.upLink});
        this.downLink = new ImageAjaxLink("down", new ResourceReference(((Object)((Object)this)).getClass(), "../img/icons/silk/arrow_down.png")){

            @Override
            protected void onClick(AjaxRequestTarget target) {
                int index = items.indexOf(UpDownPanel.this.entry);
                items.remove(index);
                items.add(Math.min(items.size(), index + 1), UpDownPanel.this.entry);
                target.addComponent(UpDownPanel.this.container);
                target.addComponent((Component)this);
                target.addComponent((Component)UpDownPanel.this.downLink);
                target.addComponent((Component)UpDownPanel.this.upLink);
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.put("title", (CharSequence)downTitle.getString());
                if (items.indexOf(entry) == items.size() - 1) {
                    tag.put("style", (CharSequence)"visibility:hidden");
                } else {
                    tag.put("style", (CharSequence)"visibility:visible");
                }
            }
        };
        this.downLink.getImage().add(new IBehavior[]{new AttributeModifier("alt", true, (IModel)new ParamResourceModel("down", (Component)this.downLink, new Object[0]))});
        this.downLink.setOutputMarkupId(true);
        this.add(new Component[]{this.downLink});
    }
}

