/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.UpDownPanel;

public abstract class ReorderableTablePanel<T>
extends GeoServerTablePanel<T> {
    static GeoServerDataProvider.Property POSITION = new GeoServerDataProvider.PropertyPlaceholder("position");
    static GeoServerDataProvider.Property RENDERING_ORDER = new GeoServerDataProvider.PropertyPlaceholder("order");
    private List<T> items;

    public ReorderableTablePanel(String id, List<T> items, List<GeoServerDataProvider.Property<T>> properties) {
        super(id, new ReorderableDataProvider<T>(items, properties));
        this.items = items;
    }

    @Override
    protected void buildRowListView(final GeoServerDataProvider<T> dataProvider, Item item, final IModel itemModel) {
        ListView items = new ListView("itemProperties", dataProvider.getVisibleProperties()){

            protected void populateItem(ListItem item) {
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)item.getModelObject();
                Object component = null;
                if (property == POSITION) {
                    ParamResourceModel upTitle = new ParamResourceModel("moveToTop", (Component)this, new Object[0]);
                    ParamResourceModel downTitle = new ParamResourceModel("moveToBottom", (Component)this, new Object[0]);
                    component = new UpDownPanel<Object>("component", itemModel.getObject(), dataProvider.getItems(), (Component)ReorderableTablePanel.this, upTitle, downTitle);
                } else {
                    component = property == RENDERING_ORDER ? new Label("component", (IModel)new Model()) : ReorderableTablePanel.this.getComponentForProperty("component", itemModel, property);
                }
                if (component == null) {
                    component = new Label("component", property.getModel(itemModel));
                } else if (!"component".equals(component.getId())) {
                    throw new IllegalArgumentException("getComponentForProperty asked to build a component with id = 'component' for property '" + property.getName() + "', but got '" + component.getId() + "' instead");
                }
                item.add(new Component[]{component});
                ReorderableTablePanel.this.onPopulateItem(property, item);
            }
        };
        items.setReuseItems(true);
        item.add(new Component[]{items});
        this.setOutputMarkupId(true);
    }

    @Override
    protected void onPopulateItem(GeoServerDataProvider.Property<T> property, ListItem item) {
        if (property == RENDERING_ORDER) {
            Label label = (Label)item.get(0);
            OddEvenItem rowContainer = (OddEvenItem)item.getParent().getParent();
            label.setDefaultModel((IModel)new Model((Serializable)Integer.valueOf(rowContainer.getIndex() + 1)));
            item.add(new IBehavior[]{new AbstractBehavior(){

                public void onComponentTag(Component component, ComponentTag tag) {
                    tag.put("style", (CharSequence)"width:1%");
                }
            }});
        }
    }

    static class ReorderableDataProvider<T>
    extends GeoServerDataProvider<T> {
        private List<T> items;
        private List<GeoServerDataProvider.Property<T>> properties;

        public ReorderableDataProvider(List<T> items, List<GeoServerDataProvider.Property<T>> properties) {
            this.items = items;
            this.properties = new ArrayList<GeoServerDataProvider.Property<T>>(properties);
            this.properties.add(0, POSITION);
            this.properties.add(0, RENDERING_ORDER);
        }

        @Override
        protected List<GeoServerDataProvider.Property<T>> getProperties() {
            return this.properties;
        }

        @Override
        protected List<T> getItems() {
            return this.items;
        }
    }
}

