/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.Serializable;
import java.util.Locale;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;

public class GeometryTextArea
extends TextArea<Geometry> {
    private static final long serialVersionUID = 1L;
    protected TextArea<String> geometry;

    public GeometryTextArea(String id) {
        this(id, (IModel<Geometry>)new Model(null));
    }

    public GeometryTextArea(String id, Geometry g) {
        this(id, (IModel<Geometry>)new Model((Serializable)g));
    }

    public GeometryTextArea(String id, IModel<Geometry> model) {
        super(id, model);
        this.setType(Geometry.class);
    }

    public IConverter getConverter(Class<?> type) {
        return new GeometryConverter();
    }

    private class GeometryConverter
    implements IConverter {
        private static final long serialVersionUID = 5868644160487841740L;
        transient GeometryFactory gf = new GeometryFactory();
        transient WKTReader reader = new WKTReader(this.gf);

        private GeometryConverter() {
        }

        public Object convertToObject(String value, Locale locale) {
            try {
                return this.reader.read(value);
            }
            catch (ParseException e) {
                try {
                    String[] values = value.split("\\s+");
                    if (values.length > 0 && values.length < 3) {
                        Coordinate c = new Coordinate();
                        c.x = Double.parseDouble(values[0]);
                        c.y = Double.parseDouble(values[1]);
                        return this.gf.createPoint(c);
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                ConversionException ce = new ConversionException((String)null);
                ce.setResourceKey(GeometryTextArea.class.getSimpleName() + ".parseError");
                throw ce;
            }
        }

        public String convertToString(Object value, Locale locale) {
            if (value instanceof Point) {
                Coordinate c = ((Point)value).getCoordinate();
                return c.x + " " + c.y;
            }
            return value.toString();
        }
    }
}

