/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public class DecimalTextField
extends TextField<Double> {
    private static final long serialVersionUID = 1L;
    private NumberFormat format = DecimalFormat.getInstance();
    private IConverter decimalConverter;

    public DecimalTextField(String id, IModel<Double> model) {
        super(id, model, Double.class);
        this.format.setMaximumFractionDigits(16);
        this.decimalConverter = new IConverter(){
            private static final long serialVersionUID = 1L;

            public String convertToString(Object value, Locale locale) {
                return value == null ? null : DecimalTextField.this.format.format(value);
            }

            public Object convertToObject(String value, Locale locale) {
                Number parsed;
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                try {
                    parsed = DecimalTextField.this.format.parse(value);
                }
                catch (ParseException e) {
                    DecimalTextField.this.error((Serializable)((Object)e.getMessage()));
                    return null;
                }
                return parsed.doubleValue();
            }
        };
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.format.setMaximumFractionDigits(maximumFractionDigits);
    }

    public IConverter getConverter(Class<?> type) {
        return this.decimalConverter;
    }
}

