/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxCallDecorator;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.request.WebClientInfo;

public class CodeMirrorEditor
extends FormComponentPanel<String> {
    public static final ResourceReference REFERENCE = new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/codemirror.js");
    public static final ResourceReference CSS_REFERENCE = new ResourceReference(CodeMirrorEditor.class, "js/codemirror/css/codemirror.css");
    public static final ResourceReference[] MODES = new ResourceReference[]{new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/xml.js"), new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/clike.js"), new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/groovy.js"), new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/javascript.js"), new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/python.js"), new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/ruby.js"), new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/css.js")};
    private TextArea<String> editor;
    private WebMarkupContainer container;
    private String mode;

    public CodeMirrorEditor(String id, String mode, IModel<String> model) {
        super(id, model);
        this.mode = mode;
        boolean enableCodeMirror = this.isCodeMirrorSupported();
        this.container = new WebMarkupContainer("editorContainer");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        WebMarkupContainer toolbar = new WebMarkupContainer("toolbar");
        toolbar.setVisible(enableCodeMirror);
        this.container.add(new Component[]{toolbar});
        WebMarkupContainer editorParent = new WebMarkupContainer("editorParent");
        if (enableCodeMirror) {
            editorParent.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)"border: 1px solid black;")});
        }
        this.container.add(new Component[]{editorParent});
        this.editor = new TextArea("editor", model);
        editorParent.add(new Component[]{this.editor});
        this.editor.setOutputMarkupId(true);
        if (enableCodeMirror) {
            this.editor.add(new IBehavior[]{new CodeMirrorBehavior()});
        } else {
            this.editor.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)"width:100%")});
        }
    }

    private boolean isCodeMirrorSupported() {
        boolean enableCodeMirror = true;
        WebClientInfo clientInfo = (WebClientInfo)WebRequestCycle.get().getClientInfo();
        ClientProperties clientProperties = clientInfo.getProperties();
        if (clientProperties.isBrowserInternetExplorer()) {
            ClientProperties props = this.extractIEVersion(clientProperties.getNavigatorUserAgent());
            enableCodeMirror = clientProperties.getBrowserVersionMajor() >= 8 || props.getBrowserVersionMajor() >= 8;
        } else if (clientProperties.isBrowserMozillaFirefox()) {
            ClientProperties props = this.extractFirefoxVersion(clientProperties.getNavigatorUserAgent());
            enableCodeMirror = clientProperties.getBrowserVersionMajor() >= 3 || props.getBrowserVersionMajor() >= 3;
        } else if (clientProperties.isBrowserSafari()) {
            ClientProperties props = this.extractSafariVersion(clientProperties.getNavigatorAppVersion());
            enableCodeMirror = clientProperties.getBrowserVersionMajor() > 5 || clientProperties.getBrowserVersionMajor() == 5 && clientProperties.getBrowserVersionMinor() >= 2 || props.getBrowserVersionMajor() > 5 || props.getBrowserVersionMajor() == 5 && props.getBrowserVersionMinor() >= 2;
        } else if (clientProperties.isBrowserOpera()) {
            ClientProperties props = this.extractOperaVersion(clientProperties.getNavigatorAppVersion());
            enableCodeMirror = clientProperties.getBrowserVersionMajor() >= 9 || props.getBrowserVersionMajor() >= 9;
        }
        return enableCodeMirror;
    }

    private ClientProperties extractIEVersion(String userAgent) {
        ClientProperties props = new ClientProperties();
        props.setBrowserVersionMajor(-1);
        props.setBrowserVersionMinor(-1);
        if (userAgent != null) {
            String userAgencyLc = userAgent.toLowerCase();
            String pattern = userAgencyLc.contains("like gecko") ? "rv:(\\d+)\\.(\\d+)" : "msie (\\d+)\\.(\\d+)";
            this.setMajorMinorVersionByPattern(userAgencyLc, pattern, props);
        }
        return props;
    }

    private ClientProperties extractFirefoxVersion(String userAgent) {
        ClientProperties props = new ClientProperties();
        props.setBrowserVersionMajor(-1);
        props.setBrowserVersionMinor(-1);
        if (userAgent != null) {
            String userAgencyLc = userAgent.toLowerCase();
            props.setBrowserVersionMajor(-1);
            props.setBrowserVersionMinor(-1);
            this.setMajorMinorVersionByPattern(userAgencyLc, "firefox/(\\d+)\\.(\\d+)", props);
        }
        return props;
    }

    private ClientProperties extractOperaVersion(String userAgent) {
        ClientProperties props = new ClientProperties();
        props.setBrowserVersionMajor(-1);
        props.setBrowserVersionMinor(-1);
        if (userAgent != null) {
            String userAgencyLc = userAgent.toLowerCase();
            if (userAgencyLc.startsWith("opera/") && userAgencyLc.contains("version/")) {
                this.setMajorMinorVersionByPattern(userAgencyLc, "version/(\\d+)\\.(\\d+)", props);
            } else if (userAgencyLc.startsWith("opera/") && !userAgencyLc.contains("version/")) {
                this.setMajorMinorVersionByPattern(userAgencyLc, "opera/(\\d+)\\.(\\d+)", props);
            } else {
                this.setMajorMinorVersionByPattern(userAgencyLc, "opera (\\d+)\\.(\\d+)", props);
            }
        }
        return props;
    }

    private ClientProperties extractSafariVersion(String userAgent) {
        ClientProperties props = new ClientProperties();
        props.setBrowserVersionMajor(-1);
        props.setBrowserVersionMinor(-1);
        if (userAgent != null) {
            String userAgencyLc = userAgent.toLowerCase();
            this.setMajorMinorVersionByPattern(userAgencyLc, "version/(\\d+)\\.(\\d+)", props);
        }
        return props;
    }

    private ClientProperties extractChromeVersion(String userAgent) {
        ClientProperties props = new ClientProperties();
        props.setBrowserVersionMajor(-1);
        props.setBrowserVersionMinor(-1);
        if (userAgent != null) {
            String userAgencyLc = userAgent.toLowerCase();
            this.setMajorMinorVersionByPattern(userAgencyLc, "chrome/(\\d+)\\.(\\d+)", props);
        }
        return props;
    }

    private void setMajorMinorVersionByPattern(String userAgent, String patternString, ClientProperties properties) {
        Matcher matcher = Pattern.compile(patternString).matcher(userAgent);
        if (matcher.find()) {
            properties.setBrowserVersionMajor(Integer.parseInt(matcher.group(1)));
            properties.setBrowserVersionMinor(Integer.parseInt(matcher.group(2)));
        }
    }

    public CodeMirrorEditor(String id, IModel<String> model) {
        this(id, "xml", model);
    }

    protected void convertInput() {
        this.editor.processInput();
        this.setConvertedInput(this.editor.getConvertedInput());
    }

    public String getInput() {
        return this.editor.getInput();
    }

    public void setTextAreaMarkupId(String id) {
        this.editor.setMarkupId(id);
    }

    public String getTextAreaMarkupId() {
        return this.editor.getMarkupId();
    }

    public void setMode(String mode) {
        this.mode = mode;
        if (AjaxRequestTarget.get() != null) {
            String javascript = "document.gsEditors." + this.editor.getMarkupId() + ".setOption('mode', '" + mode + "');";
            AjaxRequestTarget.get().appendJavascript(javascript);
        }
    }

    public void reset() {
        super.validate();
        this.editor.validate();
        this.editor.clearInput();
    }

    public IAjaxCallDecorator getSaveDecorator() {
        return new AjaxCallDecorator(){

            public CharSequence decorateScript(CharSequence script) {
                String id = CodeMirrorEditor.this.getTextAreaMarkupId();
                return "if (document.gsEditors) { document.getElementById('" + id + "').value = document.gsEditors." + id + ".getValue(); }" + script;
            }
        };
    }

    class CodeMirrorBehavior
    extends AbstractBehavior {
        CodeMirrorBehavior() {
        }

        public void renderHead(IHeaderResponse response) {
            super.renderHead(response);
            response.renderCSSReference(CSS_REFERENCE);
            response.renderJavascriptReference(REFERENCE);
            for (ResourceReference mode : MODES) {
                response.renderJavascriptReference(mode);
            }
            response.renderOnDomReadyJavascript(this.getInitJavascript());
        }

        private String getInitJavascript() {
            InputStream is = CodeMirrorEditor.class.getResourceAsStream("CodeMirrorEditor.js");
            String js = this.convertStreamToString(is);
            js = js.replaceAll("\\$componentId", CodeMirrorEditor.this.editor.getMarkupId());
            js = js.replaceAll("\\$mode", CodeMirrorEditor.this.mode);
            js = js.replaceAll("\\$container", CodeMirrorEditor.this.container.getMarkupId());
            return js;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String convertStreamToString(InputStream is) {
            try {
                if (is != null) {
                    StringWriter writer = new StringWriter();
                    char[] buffer = new char[1024];
                    try {
                        int n;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    finally {
                        is.close();
                    }
                    return ((Object)writer).toString();
                }
                return "";
            }
            catch (IOException e) {
                throw new RuntimeException("Did not expect this one...", e);
            }
        }
    }
}

