/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.util.converters;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Converter;
import org.opengis.referencing.IdentifiedObject;

public class StringBBoxConverter
implements Converter {
    private static String SEPARATOR = ",";

    public <T> T convert(Object source, Class<T> target) throws Exception {
        if (source instanceof ReferencedEnvelope) {
            if (String.class.isAssignableFrom(target)) {
                try {
                    ReferencedEnvelope envelope = (ReferencedEnvelope)source;
                    StringBuilder str = new StringBuilder();
                    str.append(envelope.getMinimum(0)).append(SEPARATOR);
                    str.append(envelope.getMaximum(0)).append(SEPARATOR);
                    str.append(envelope.getMinimum(1)).append(SEPARATOR);
                    str.append(envelope.getMaximum(1)).append(SEPARATOR);
                    str.append(CRS.lookupIdentifier((IdentifiedObject)envelope.getCoordinateReferenceSystem(), (boolean)true));
                    return (T)str.toString();
                }
                catch (Exception e) {
                    return null;
                }
            }
        } else if (ReferencedEnvelope.class.isAssignableFrom(target)) {
            String text = (String)source;
            String[] parsed = text.split("\\s*" + SEPARATOR + "\\s*");
            try {
                return (T)new ReferencedEnvelope(new Envelope(Double.valueOf(parsed[0]).doubleValue(), Double.valueOf(parsed[1]).doubleValue(), Double.valueOf(parsed[2]).doubleValue(), Double.valueOf(parsed[3]).doubleValue()), CRS.decode((String)parsed[4]));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new IllegalArgumentException("String List converter expects to convert ReferencedEnvelope <-> string only. (" + source + "), (" + target + ")");
    }
}

