/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.services;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.workspace.WorkspaceChoiceRenderer;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geoserver.web.services.AdminPagePanel;
import org.geoserver.web.services.AdminPagePanelInfo;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geoserver.web.wicket.LiveCollectionModel;

public abstract class BaseServiceAdminPage<T extends ServiceInfo>
extends GeoServerSecuredPage {
    protected GeoServerDialog dialog;

    public BaseServiceAdminPage() {
        this(new PageParameters());
    }

    public BaseServiceAdminPage(PageParameters pageParams) {
        String wsName = pageParams.getString("workspace");
        this.init((IModel<T>)new ServiceModel<T>(this, this.getServiceClass(), wsName));
    }

    public BaseServiceAdminPage(T service) {
        this.init((IModel<T>)new ServiceModel(this, service));
    }

    void init(final IModel<T> infoModel) {
        ServiceInfo service = (ServiceInfo)infoModel.getObject();
        this.dialog = new GeoServerDialog("dialog");
        this.add(new Component[]{this.dialog});
        Form form = new Form("form", (IModel)new CompoundPropertyModel(infoModel));
        this.add(new Component[]{form});
        if (service.getWorkspace() == null) {
            form.add(new Component[]{new GlobalWorkspacePanel("workspace")});
        } else {
            form.add(new Component[]{new LocalWorkspacePanel(this, "workspace", service)});
        }
        form.add(new Component[]{new HelpLink("workspaceHelp").setDialog(this.dialog)});
        form.add(new Component[]{new Label("service.enabled", (IModel)new StringResourceModel("service.enabled", (Component)this, null, new Object[]{this.getServiceName()}))});
        form.add(new Component[]{new TextField("maintainer")});
        TextField onlineResource = new TextField("onlineResource");
        onlineResource.add((IValidator)new UrlValidator());
        form.add(new Component[]{onlineResource});
        form.add(new Component[]{new CheckBox("enabled")});
        form.add(new Component[]{new CheckBox("citeCompliant")});
        form.add(new Component[]{new TextField("title")});
        form.add(new Component[]{new TextArea("abstract")});
        form.add(new Component[]{new KeywordsEditor("keywords", LiveCollectionModel.list((IModel)new PropertyModel(infoModel, "keywords")))});
        form.add(new Component[]{new TextField("fees")});
        form.add(new Component[]{new TextField("accessConstraints")});
        this.build(infoModel, form);
        ListView extensionPanels = this.createExtensionPanelList("extensions", infoModel);
        extensionPanels.setReuseItems(true);
        form.add(new Component[]{extensionPanels});
        SubmitLink submit = new SubmitLink("submit", (IModel)new StringResourceModel("save", (Component)null, null)){

            public void onSubmit() {
                try {
                    BaseServiceAdminPage.this.handleSubmit((ServiceInfo)infoModel.getObject());
                    BaseServiceAdminPage.this.doReturn();
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        };
        form.add(new Component[]{submit});
        Button cancel = new Button("cancel", (IModel)new StringResourceModel("cancel", (Component)null, null)){

            public void onSubmit() {
                BaseServiceAdminPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    protected ListView createExtensionPanelList(String id, final IModel infoModel) {
        List<AdminPagePanelInfo> panels = this.getGeoServerApplication().getBeansOfType(AdminPagePanelInfo.class);
        Iterator<AdminPagePanelInfo> it = panels.iterator();
        while (it.hasNext()) {
            AdminPagePanelInfo panel = it.next();
            if (this.getServiceClass().equals(panel.getServiceClass())) continue;
            it.remove();
        }
        return new ListView<AdminPagePanelInfo>(id, panels){

            protected void populateItem(ListItem<AdminPagePanelInfo> item) {
                AdminPagePanelInfo info = (AdminPagePanelInfo)item.getModelObject();
                try {
                    AdminPagePanel panel = (AdminPagePanel)((Object)info.getComponentClass().getConstructor(String.class, IModel.class).newInstance("content", infoModel));
                    item.add(new Component[]{panel});
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Failed to create admin extension panel of type " + info.getComponentClass().getSimpleName(), (Throwable)e);
                }
            }
        };
    }

    protected abstract Class<T> getServiceClass();

    protected abstract void build(IModel var1, Form var2);

    protected void handleSubmit(T info) {
        if (info.getId() != null) {
            this.getGeoServer().save(info);
        }
    }

    protected abstract String getServiceName();

    static class LocalWorkspacePanel
    extends Panel {
        final /* synthetic */ BaseServiceAdminPage this$0;

        public LocalWorkspacePanel(String id, T service) {
            this.this$0 = var1_1;
            super(id);
            this.add(new Component[]{new Label("workspace", (IModel)new PropertyModel(service, "workspace.name"))});
        }
    }

    class GlobalWorkspacePanel
    extends Panel {
        public GlobalWorkspacePanel(String id) {
            super(id);
            final DropDownChoice wsChoice = new DropDownChoice("workspace", (IModel)new ServiceFilteredWorkspacesModel(new WorkspacesModel()), (IChoiceRenderer)new WorkspaceChoiceRenderer());
            wsChoice.setNullValid(true);
            wsChoice.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    WorkspaceInfo ws = (WorkspaceInfo)wsChoice.getModelObject();
                    PageParameters pp = new PageParameters();
                    if (ws != null) {
                        pp.put("workspace", (Object)ws.getName());
                    }
                    GlobalWorkspacePanel.this.setResponsePage(((Object)((Object)BaseServiceAdminPage.this)).getClass(), pp);
                }
            }});
            this.add(new Component[]{wsChoice});
        }
    }

    class ServiceFilteredWorkspacesModel
    extends LoadableDetachableModel {
        WorkspacesModel wsModel;

        ServiceFilteredWorkspacesModel(WorkspacesModel wsModel) {
            this.wsModel = wsModel;
        }

        protected Object load() {
            Collection workspaces = (Collection)this.wsModel.getObject();
            GeoServer gs = BaseServiceAdminPage.this.getGeoServer();
            Iterator it = workspaces.iterator();
            while (it.hasNext()) {
                if (gs.getService((WorkspaceInfo)it.next(), BaseServiceAdminPage.this.getServiceClass()) != null) continue;
                it.remove();
            }
            return workspaces;
        }
    }

    static class ServiceModel<T extends ServiceInfo>
    extends LoadableDetachableModel<T> {
        String id;
        Class<T> serviceClass;
        String workspaceName;
        T service;
        final /* synthetic */ BaseServiceAdminPage this$0;

        ServiceModel(T service) {
            this.this$0 = var1_1;
            this.id = service.getId();
            if (this.id == null) {
                this.service = service;
            }
        }

        ServiceModel(BaseServiceAdminPage baseServiceAdminPage, Class<T> serviceClass, String workspaceName) {
            this.this$0 = baseServiceAdminPage;
            this.serviceClass = serviceClass;
            this.workspaceName = workspaceName;
        }

        protected T load() {
            if (this.id != null) {
                return (T)this.this$0.getGeoServer().getService(this.id, this.this$0.getServiceClass());
            }
            if (this.serviceClass != null) {
                if (this.workspaceName != null) {
                    WorkspaceInfo ws = this.this$0.getCatalog().getWorkspaceByName(this.workspaceName);
                    return (T)this.this$0.getGeoServer().getService(ws, this.this$0.getServiceClass());
                }
                return (T)this.this$0.getGeoServer().getService(this.this$0.getServiceClass());
            }
            return this.service;
        }

        public void detach() {
            this.service = this.id == null && this.serviceClass == null ? (ServiceInfo)this.getObject() : null;
        }
    }
}

