/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.publish;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.ComponentInfo;
import org.geoserver.web.publish.LayerConfigurationPanel;
import org.geotools.util.logging.Logging;

public class LayerConfigurationPanelInfo
extends ComponentInfo<LayerConfigurationPanel> {
    public static final long serialVersionUID = -1L;
    private static Logger LOGGER = Logging.getLogger((String)"org.geoserver.config");
    private List<String> myHandleableClasses;

    public void setSupportedTypes(List<String> types) {
        this.myHandleableClasses = types;
    }

    public List<String> getSupportedTypes() {
        return Collections.unmodifiableList(this.myHandleableClasses);
    }

    public boolean canHandle(LayerInfo layer) {
        if (this.myHandleableClasses == null) {
            return true;
        }
        for (String className : this.myHandleableClasses) {
            try {
                if (!Class.forName(className).isInstance(layer.getResource())) continue;
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.severe("Couldn't find class " + className + "; please check your applicationContext.xml");
            }
        }
        return false;
    }
}

