/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.data.store.AbstractWMSStorePage;
import org.geoserver.web.data.store.StoreConnectionFailedInformationPanel;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geotools.data.wms.WebMapServer;

public class WMSStoreEditPage
extends AbstractWMSStorePage {
    public static final String STORE_NAME = "storeName";
    public static final String WS_NAME = "wsName";

    public WMSStoreEditPage(PageParameters parameters) {
        String wsName = parameters.getString(WS_NAME);
        String storeName = parameters.getString(STORE_NAME);
        WMSStoreInfo store = (WMSStoreInfo)this.getCatalog().getStoreByName(wsName, storeName, WMSStoreInfo.class);
        this.initUI(store);
    }

    public WMSStoreEditPage(WMSStoreInfo store) {
        this.initUI(store);
    }

    @Override
    protected void onSave(WMSStoreInfo info, AjaxRequestTarget target) throws IllegalArgumentException {
        if (!info.isEnabled()) {
            this.doSaveStore(info);
        } else {
            try {
                this.getCatalog().getResourcePool().clear(info);
                WebMapServer webMapServer = this.getCatalog().getResourcePool().getWebMapServer(info);
                webMapServer.getCapabilities();
                this.doSaveStore(info);
            }
            catch (Exception e) {
                this.confirmSaveOnConnectionFailure(info, target, e);
            }
        }
    }

    protected void doSaveStore(WMSStoreInfo info) {
        this.getCatalog().validate((StoreInfo)info, false).throwIfInvalid();
        this.getCatalog().save((StoreInfo)info);
        this.doReturn(StorePage.class);
    }

    private void confirmSaveOnConnectionFailure(final WMSStoreInfo info, AjaxRequestTarget requestTarget, Exception error) {
        this.getCatalog().getResourcePool().clear(info);
        String message = error.getMessage();
        if (message == null && error.getCause() != null) {
            message = error.getCause().getMessage();
        }
        final String exceptionMessage = message;
        this.dialog.showOkCancel(requestTarget, new GeoServerDialog.DialogDelegate(){
            boolean accepted = false;

            @Override
            protected Component getContents(String id) {
                return new StoreConnectionFailedInformationPanel(id, info.getName(), exceptionMessage);
            }

            @Override
            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                WMSStoreEditPage.this.doSaveStore(info);
                this.accepted = true;
                return true;
            }

            @Override
            protected boolean onCancel(AjaxRequestTarget target) {
                return true;
            }

            @Override
            public void onClose(AjaxRequestTarget target) {
                if (this.accepted) {
                    WMSStoreEditPage.this.doReturn(StorePage.class);
                }
            }
        });
    }
}

