/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.markup.html.form.Form;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.ComponentInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.DataStorePanelInfo;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataAccessFactory;

public class StoreExtensionPoints {
    private StoreExtensionPoints() {
    }

    public static StoreEditPanel getStoreEditPanel(String componentId, Form editForm, StoreInfo storeInfo, GeoServerApplication app) {
        StoreEditPanel storeEditPanel;
        Constructor constructor;
        if (storeInfo == null) {
            throw new NullPointerException("storeInfo param");
        }
        if (app == null) {
            throw new NullPointerException("GeoServerApplication param");
        }
        DataStorePanelInfo panelInfo = StoreExtensionPoints.findPanelInfo(storeInfo, app);
        if (panelInfo == null || panelInfo.getComponentClass() == null) {
            panelInfo = StoreExtensionPoints.getDefaultPanelInfo(storeInfo, app);
        }
        Class componentClass = panelInfo.getComponentClass();
        try {
            constructor = componentClass.getConstructor(String.class, Form.class);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(componentClass.getName() + " does not provide the required constructor");
        }
        try {
            storeEditPanel = (StoreEditPanel)((Object)constructor.newInstance(componentId, editForm));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate extension point contributor " + componentClass.getName(), e);
        }
        return storeEditPanel;
    }

    private static DataStorePanelInfo getDefaultPanelInfo(StoreInfo storeInfo, GeoServerApplication app) {
        List<DataStorePanelInfo> providers = app.getBeansOfType(DataStorePanelInfo.class);
        ComponentInfo panelInfo = null;
        for (DataStorePanelInfo provider : providers) {
            if (storeInfo instanceof DataStoreInfo && "defaultVector".equals(provider.getId())) {
                panelInfo = provider;
                break;
            }
            if (!(storeInfo instanceof CoverageStoreInfo) || !"defaultRaster".equals(provider.getId())) continue;
            panelInfo = provider;
            break;
        }
        if (panelInfo == null) {
            if (storeInfo instanceof DataStoreInfo) {
                throw new IllegalStateException("Bean of type DataStorePanelInfo named 'defaultDataStorePanel' not provided by application context");
            }
            if (storeInfo instanceof CoverageStoreInfo) {
                throw new IllegalStateException("Bean of type DataStorePanelInfo named 'defaultCoverageStorePanel' not provided by application context");
            }
            throw new IllegalArgumentException("Unknown store type: " + storeInfo.getClass().getName());
        }
        if (panelInfo.getComponentClass() == null) {
            throw new IllegalStateException("Default DataStorePanelInfo '" + panelInfo.getId() + "' does not define a componentClass property");
        }
        if (((DataStorePanelInfo)panelInfo).getIconBase() == null || ((DataStorePanelInfo)panelInfo).getIcon() == null) {
            throw new IllegalStateException("Default DataStorePanelInfo '" + panelInfo.getId() + "' does not define default icon");
        }
        return panelInfo;
    }

    private static DataStorePanelInfo findPanelInfo(StoreInfo storeInfo, GeoServerApplication app) {
        Catalog catalog = storeInfo.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        Class<?> factoryClass = null;
        if (storeInfo instanceof DataStoreInfo) {
            DataAccessFactory storeFactory;
            try {
                storeFactory = resourcePool.getDataStoreFactory((DataStoreInfo)storeInfo);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("no factory found for StoreInfo " + storeInfo);
            }
            if (storeFactory != null) {
                factoryClass = storeFactory.getClass();
            }
        } else if (storeInfo instanceof CoverageStoreInfo) {
            AbstractGridFormat gridFormat = resourcePool.getGridCoverageFormat((CoverageStoreInfo)storeInfo);
            if (gridFormat != null) {
                factoryClass = gridFormat.getClass();
            }
        } else {
            throw new IllegalArgumentException("Unknown store type: " + storeInfo.getClass().getName());
        }
        if (factoryClass == null) {
            throw new IllegalArgumentException("Can't locate the factory for the store");
        }
        List<DataStorePanelInfo> providers = app.getBeansOfType(DataStorePanelInfo.class);
        ArrayList<DataStorePanelInfo> fallbacks = new ArrayList<DataStorePanelInfo>();
        for (DataStorePanelInfo provider : providers) {
            Class<?> providerFactoryClass = provider.getFactoryClass();
            if (providerFactoryClass == null) continue;
            if (factoryClass.equals(providerFactoryClass)) {
                return provider;
            }
            if (!providerFactoryClass.isAssignableFrom(factoryClass)) continue;
            fallbacks.add(provider);
        }
        if (fallbacks.size() == 1) {
            return (DataStorePanelInfo)fallbacks.get(0);
        }
        if (fallbacks.size() > 1) {
            Collections.sort(fallbacks, new Comparator<DataStorePanelInfo>(){

                @Override
                public int compare(DataStorePanelInfo o1, DataStorePanelInfo o2) {
                    Class<?> c2;
                    Class<?> c1 = o1.getFactoryClass();
                    if (c1.equals(c2 = o2.getFactoryClass())) {
                        return 0;
                    }
                    if (c1.isAssignableFrom(c2)) {
                        return 1;
                    }
                    if (c2.isAssignableFrom(c1)) {
                        // empty if block
                    }
                    return -1;
                }
            });
            DataStorePanelInfo f1 = (DataStorePanelInfo)fallbacks.get(0);
            DataStorePanelInfo f2 = (DataStorePanelInfo)fallbacks.get(1);
            if (f1.getFactoryClass().equals(f2.getFactoryClass())) {
                String msg = "Multiple editor panels for : (" + f1.getFactoryClass() + "): " + f1 + ", " + f2;
                throw new RuntimeException(msg);
            }
            return f1;
        }
        return null;
    }
}

