/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.store.CoverageStoreNewPage;
import org.geoserver.web.data.store.DataAccessNewPage;
import org.geoserver.web.data.store.WMSStoreNewPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.DataAccessFactory;
import org.opengis.coverage.grid.Format;
import org.vfny.geoserver.util.DataStoreUtils;

public class NewDataPage
extends GeoServerSecuredPage {
    private transient Map<String, DataAccessFactory> dataStores = this.getAvailableDataStores();
    private transient Map<String, Format> coverages = this.getAvailableCoverageStores();

    public NewDataPage() {
        boolean thereAreWorkspaces;
        boolean bl = thereAreWorkspaces = !this.getCatalog().getWorkspaces().isEmpty();
        if (!thereAreWorkspaces) {
            super.error((Serializable)((Object)new ResourceModel("NewDataPage.noWorkspacesErrorMessage").getObject()));
        }
        Form storeForm = new Form("storeForm");
        this.add(new Component[]{storeForm});
        ArrayList<String> sortedDsNames = new ArrayList<String>(this.getAvailableDataStores().keySet());
        Collections.sort(sortedDsNames);
        final CatalogIconFactory icons = CatalogIconFactory.get();
        ListView dataStoreLinks = new ListView("vectorResources", sortedDsNames){

            protected void populateItem(ListItem item) {
                final String dataStoreFactoryName = item.getDefaultModelObjectAsString();
                DataAccessFactory factory = (DataAccessFactory)NewDataPage.this.getAvailableDataStores().get(dataStoreFactoryName);
                String description = factory.getDescription();
                SubmitLink link = new SubmitLink("resourcelink"){

                    public void onSubmit() {
                        this.setResponsePage((Page)new DataAccessNewPage(dataStoreFactoryName));
                    }
                };
                link.setEnabled(thereAreWorkspaces);
                link.add(new Component[]{new Label("resourcelabel", dataStoreFactoryName)});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("resourceDescription", description)});
                Image icon = new Image("storeIcon", icons.getStoreIcon(factory.getClass()));
                icon.add(new IBehavior[]{new AttributeModifier("alt", true, (IModel)new Model((Serializable)((Object)"")))});
                item.add(new Component[]{icon});
            }
        };
        ArrayList<String> sortedCoverageNames = new ArrayList<String>();
        sortedCoverageNames.addAll(this.getAvailableCoverageStores().keySet());
        Collections.sort(sortedCoverageNames);
        ListView coverageLinks = new ListView("rasterResources", sortedCoverageNames){

            protected void populateItem(ListItem item) {
                final String coverageFactoryName = item.getDefaultModelObjectAsString();
                Map coverages = NewDataPage.this.getAvailableCoverageStores();
                Format format = (Format)coverages.get(coverageFactoryName);
                String description = format.getDescription();
                SubmitLink link = new SubmitLink("resourcelink"){

                    public void onSubmit() {
                        this.setResponsePage((Page)new CoverageStoreNewPage(coverageFactoryName));
                    }
                };
                link.setEnabled(thereAreWorkspaces);
                link.add(new Component[]{new Label("resourcelabel", coverageFactoryName)});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("resourceDescription", description)});
                Image icon = new Image("storeIcon", icons.getStoreIcon(format.getClass()));
                icon.add(new IBehavior[]{new AttributeModifier("alt", true, (IModel)new Model((Serializable)((Object)"")))});
                item.add(new Component[]{icon});
            }
        };
        List<OtherStoreDescription> otherStores = this.getOtherStores();
        ListView otherStoresLinks = new ListView("otherStores", otherStores){

            protected void populateItem(ListItem item) {
                final OtherStoreDescription store = (OtherStoreDescription)item.getModelObject();
                SubmitLink link = new SubmitLink("resourcelink"){

                    public void onSubmit() {
                        this.setResponsePage(store.configurationPage);
                    }
                };
                link.setEnabled(thereAreWorkspaces);
                link.add(new Component[]{new Label("resourcelabel", (IModel)new ParamResourceModel("other." + store.key, (Component)NewDataPage.this, new Object[0]))});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("resourceDescription", (IModel)new ParamResourceModel("other." + store.key + ".description", (Component)NewDataPage.this, new Object[0]))});
                Image icon = new Image("storeIcon", store.icon);
                icon.add(new IBehavior[]{new AttributeModifier("alt", true, (IModel)new Model((Serializable)((Object)"")))});
                item.add(new Component[]{icon});
            }
        };
        storeForm.add(new Component[]{dataStoreLinks});
        storeForm.add(new Component[]{coverageLinks});
        storeForm.add(new Component[]{otherStoresLinks});
    }

    private Map<String, DataAccessFactory> getAvailableDataStores() {
        if (this.dataStores == null) {
            Iterator availableDataStores = DataStoreUtils.getAvailableDataStoreFactories().iterator();
            HashMap<String, DataAccessFactory> storeNames = new HashMap<String, DataAccessFactory>();
            while (availableDataStores.hasNext()) {
                DataAccessFactory factory = (DataAccessFactory)availableDataStores.next();
                if (factory.getDisplayName() == null) continue;
                storeNames.put(factory.getDisplayName(), factory);
            }
            this.dataStores = storeNames;
        }
        return this.dataStores;
    }

    private Map<String, Format> getAvailableCoverageStores() {
        if (this.coverages == null) {
            Format[] availableFormats = GridFormatFinder.getFormatArray();
            HashMap<String, Format> formatNames = new HashMap<String, Format>();
            for (Format format : availableFormats) {
                formatNames.put(format.getName(), format);
            }
            this.coverages = formatNames;
        }
        return this.coverages;
    }

    private List<OtherStoreDescription> getOtherStores() {
        ArrayList<OtherStoreDescription> stores = new ArrayList<OtherStoreDescription>();
        ResourceReference wmsIcon = new ResourceReference(GeoServerApplication.class, "img/icons/geosilk/server_map.png");
        stores.add(new OtherStoreDescription("wms", wmsIcon, WMSStoreNewPage.class));
        return stores;
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    static class OtherStoreDescription
    implements Serializable {
        String key;
        ResourceReference icon;
        Class<? extends Page> configurationPage;

        public OtherStoreDescription(String key, ResourceReference icon, Class<? extends Page> configurationPage) {
            this.key = key;
            this.icon = icon;
            this.configurationPage = configurationPage;
        }
    }
}

