/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.util.logging.Level;
import javax.management.RuntimeErrorException;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.AbstractCoverageStorePage;

public class CoverageStoreNewPage
extends AbstractCoverageStorePage {
    public CoverageStoreNewPage(String coverageFactoryName) {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspace = catalog.getDefaultWorkspace();
        CoverageStoreInfo store = catalog.getFactory().createCoverageStore();
        store.setWorkspace(workspace);
        store.setType(coverageFactoryName);
        store.setEnabled(true);
        store.setURL("file:data/example.extension");
        this.initUI(store);
    }

    @Override
    protected void onSave(CoverageStoreInfo info, AjaxRequestTarget target) throws IllegalArgumentException {
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo savedStore = catalog.getFactory().createCoverageStore();
        this.clone(info, savedStore);
        try {
            catalog.validate((StoreInfo)savedStore, false).throwIfInvalid();
            catalog.save((StoreInfo)savedStore);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, "Adding the store for " + info.getURL(), e);
            throw new IllegalArgumentException("The coverage store could not be saved. Failure message: " + e.getMessage());
        }
        this.onSuccessfulSave(info, catalog, savedStore);
    }

    protected void onSuccessfulSave(CoverageStoreInfo info, Catalog catalog, CoverageStoreInfo savedStore) {
        NewLayerPage layerChooserPage;
        try {
            layerChooserPage = new NewLayerPage(savedStore.getId());
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, "Getting list of coverages for saved store " + info.getURL(), e);
            try {
                catalog.remove((StoreInfo)savedStore);
            }
            catch (RuntimeErrorException shouldNotHappen) {
                LOGGER.log(Level.WARNING, "Can't remove CoverageStoreInfo after adding it!", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.setResponsePage((Page)layerChooserPage);
    }
}

