/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.store.StoreNameValidator;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.PasswordParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;

abstract class AbstractWMSStorePage
extends GeoServerSecuredPage {
    protected WorkspacePanel workspacePanel;
    private Form form;
    GeoServerDialog dialog;
    TextParamPanel capabilitiesURL;
    protected TextParamPanel usernamePanel;
    protected PasswordParamPanel password;

    AbstractWMSStorePage() {
    }

    void initUI(WMSStoreInfo store) {
        Model model = new Model((Serializable)store);
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.form = new Form("form", (IModel)model);
        this.add(new Component[]{this.form});
        PropertyModel nameModel = new PropertyModel((Object)model, "name");
        TextParamPanel namePanel = new TextParamPanel("namePanel", (IModel)nameModel, (IModel)new ResourceModel("AbstractWMSStorePage.dataSrcName", "Data Source Name"), true, new IValidator[0]);
        this.form.add(new Component[]{namePanel});
        this.form.add(new Component[]{new TextParamPanel("descriptionPanel", (IModel)new PropertyModel((Object)model, "description"), (IModel)new ResourceModel("AbstractWMSStorePage.description", "Description"), false, new IValidator[0])});
        this.form.add(new Component[]{new CheckBoxParamPanel("enabledPanel", (IModel)new PropertyModel((Object)model, "enabled"), (IModel)new ResourceModel("enabled", "Enabled"))});
        this.workspacePanel = new WorkspacePanel("workspacePanel", (IModel)new PropertyModel((Object)model, "workspace"), (IModel)new ResourceModel("workspace", "Workspace"), true);
        this.form.add(new Component[]{this.workspacePanel});
        this.capabilitiesURL = new TextParamPanel("capabilitiesURL", (IModel)new PropertyModel((Object)model, "capabilitiesURL"), (IModel)new ParamResourceModel("capabilitiesURL", (Component)this, new Object[0]), true, new IValidator[0]);
        this.form.add(new Component[]{this.capabilitiesURL});
        PropertyModel userModel = new PropertyModel((Object)model, "username");
        this.usernamePanel = new TextParamPanel("userNamePanel", (IModel)userModel, (IModel)new ResourceModel("AbstractWMSStorePage.userName"), false, new IValidator[0]);
        this.form.add(new Component[]{this.usernamePanel});
        PropertyModel passwordModel = new PropertyModel((Object)model, "password");
        Component[] componentArray2 = new Component[1];
        this.password = new PasswordParamPanel("passwordPanel", (IModel)passwordModel, (IModel)new ResourceModel("AbstractWMSStorePage.password"), false);
        componentArray2[0] = this.password;
        this.form.add(componentArray2);
        final PropertyModel useHttpConnectionPoolModel = new PropertyModel((Object)model, "useConnectionPooling");
        CheckBoxParamPanel useConnectionPooling = new CheckBoxParamPanel("useConnectionPoolingPanel", (IModel)useHttpConnectionPoolModel, (IModel)new ResourceModel("AbstractWMSStorePage.useHttpConnectionPooling"));
        this.form.add(new Component[]{useConnectionPooling});
        PropertyModel connectionsModel = new PropertyModel((Object)model, "maxConnections");
        final TextParamPanel maxConnections = new TextParamPanel("maxConnectionsPanel", (IModel)connectionsModel, (IModel)new ResourceModel("AbstractWMSStorePage.maxConnections"), true, new IValidator[]{new RangeValidator((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(128))});
        maxConnections.setOutputMarkupId(true);
        maxConnections.setEnabled((Boolean)useHttpConnectionPoolModel.getObject());
        this.form.add(new Component[]{maxConnections});
        useConnectionPooling.getFormComponent().add(new IBehavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean enabled = (Boolean)useHttpConnectionPoolModel.getObject();
                maxConnections.setEnabled(enabled);
                target.addComponent((Component)maxConnections);
            }
        }});
        PropertyModel connectTimeoutModel = new PropertyModel((Object)model, "connectTimeout");
        this.form.add(new Component[]{new TextParamPanel("connectTimeoutPanel", (IModel)connectTimeoutModel, (IModel)new ResourceModel("AbstractWMSStorePage.connectTimeout"), true, new IValidator[]{new RangeValidator((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(240))})});
        PropertyModel readTimeoutModel = new PropertyModel((Object)model, "readTimeout");
        this.form.add(new Component[]{new TextParamPanel("readTimeoutPanel", (IModel)readTimeoutModel, (IModel)new ResourceModel("AbstractWMSStorePage.readTimeout"), true, new IValidator[]{new RangeValidator((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(360))})});
        this.form.add(new Component[]{new BookmarkablePageLink("cancel", StorePage.class)});
        this.form.add(new Component[]{this.saveLink()});
        this.form.setDefaultButton((IFormSubmittingComponent)this.saveLink());
        this.form.add(new Component[]{new FeedbackPanel("feedback")});
        StoreNameValidator storeNameValidator = new StoreNameValidator(this.workspacePanel.getFormComponent(), namePanel.getFormComponent(), store.getId());
        this.form.add((IFormValidator)storeNameValidator);
    }

    private AjaxSubmitLink saveLink() {
        return new AjaxSubmitLink("save", this.form){

            protected void onError(AjaxRequestTarget target, Form form) {
                super.onError(target, form);
                target.addComponent((Component)form);
            }

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                form.process();
                WMSStoreInfo info = (WMSStoreInfo)form.getModelObject();
                try {
                    AbstractWMSStorePage.this.onSave(info, target);
                }
                catch (IllegalArgumentException e) {
                    form.error((Serializable)((Object)e.getMessage()));
                    target.addComponent((Component)form);
                }
            }
        };
    }

    protected abstract void onSave(WMSStoreInfo var1, AjaxRequestTarget var2) throws IllegalArgumentException;

    protected void clone(WMSStoreInfo source, WMSStoreInfo target) {
        target.setDescription(source.getDescription());
        target.setEnabled(source.isEnabled());
        target.setName(source.getName());
        target.setType(source.getType());
        target.setCapabilitiesURL(source.getCapabilitiesURL());
        target.setWorkspace(source.getWorkspace());
        target.setUsername(source.getUsername());
        target.setPassword(source.getPassword());
        target.setUseConnectionPooling(source.isUseConnectionPooling());
        target.setMaxConnections(source.getMaxConnections());
        target.setConnectTimeout(source.getConnectTimeout());
        target.setReadTimeout(source.getReadTimeout());
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

