/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.web.data.resource.DimensionEditor;
import org.geoserver.web.data.resource.LayerEditTabPanel;
import org.geoserver.web.util.MetadataMapModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.logging.Logging;

public class ResourceDimensionsTabPanelInfo
extends LayerEditTabPanel {
    static final Logger LOGGER = Logging.getLogger(ResourceDimensionsTabPanelInfo.class);

    public ResourceDimensionsTabPanelInfo(String id, IModel model) {
        super(id, model);
        LayerInfo layer = (LayerInfo)model.getObject();
        final ResourceInfo resource = layer.getResource();
        PropertyModel metadata = new PropertyModel((Object)model, "resource.metadata");
        MetadataMapModel time = new MetadataMapModel((IModel)metadata, "time", DimensionInfo.class);
        if (time.getObject() == null) {
            time.setObject(new DimensionInfoImpl());
        }
        this.add(new Component[]{new DimensionEditor("time", time, resource, Date.class)});
        MetadataMapModel elevation = new MetadataMapModel((IModel)metadata, "elevation", DimensionInfo.class);
        if (elevation.getObject() == null) {
            elevation.setObject(new DimensionInfoImpl());
        }
        this.add(new Component[]{new DimensionEditor("elevation", elevation, resource, Number.class)});
        final ArrayList<RasterDimensionModel> customDimensionModels = new ArrayList<RasterDimensionModel>();
        if (resource instanceof CoverageInfo) {
            CoverageInfo ci = (CoverageInfo)resource;
            try {
                GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
                ReaderDimensionsAccessor ra = new ReaderDimensionsAccessor(reader);
                for (String domain : ra.getCustomDomains()) {
                    boolean hasResolution;
                    boolean hasRange;
                    RasterDimensionModel mm = new RasterDimensionModel((IModel)metadata, domain, DimensionInfo.class, hasRange = ra.hasRange(domain), hasResolution = ra.hasResolution(domain));
                    if (mm.getObject() == null) {
                        mm.setObject(new DimensionInfoImpl());
                    }
                    customDimensionModels.add(mm);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to access coverage reader custom dimensions", e);
            }
        }
        RefreshingView customDimensionsEditor = new RefreshingView("customDimensions"){

            protected Iterator getItemModels() {
                return customDimensionModels.iterator();
            }

            protected void populateItem(Item item) {
                RasterDimensionModel model = (RasterDimensionModel)item.getModel();
                ParamResourceModel customDimension = new ParamResourceModel("customDimension", (Component)ResourceDimensionsTabPanelInfo.this, new Object[0]);
                item.add(new Component[]{new Label("dimensionName", customDimension.getString() + ": " + model.getExpression())});
                DimensionEditor editor = new DimensionEditor("dimension", model, resource, String.class);
                editor.disablePresentationMode(DimensionPresentation.CONTINUOUS_INTERVAL);
                if (!model.hasRange && !model.hasResolution) {
                    editor.disablePresentationMode(DimensionPresentation.DISCRETE_INTERVAL);
                }
                item.add(new Component[]{editor});
            }
        };
        this.add(new Component[]{customDimensionsEditor});
        customDimensionsEditor.setVisible(customDimensionModels.size() > 0);
    }

    class RasterDimensionModel
    extends MetadataMapModel {
        boolean hasRange;
        boolean hasResolution;

        public RasterDimensionModel(IModel model, String expression, Class<?> target, boolean hasRange, boolean hasResolution) {
            super(model, expression, target);
        }

        @Override
        public Object getObject() {
            return ((MetadataMap)this.model.getObject()).get("custom_dimension_" + this.expression, this.target);
        }

        @Override
        public void setObject(Object object) {
            ((MetadataMap)this.model.getObject()).put("custom_dimension_" + this.expression, (Serializable)object);
        }
    }
}

