/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layer.CascadedWFSStoredQueryEditPage;
import org.geoserver.web.data.layer.SQLViewEditPage;
import org.geoserver.web.data.resource.ResourceConfigurationException;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.data.wfs.internal.v2_0.storedquery.StoredQueryConfiguration;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.jdbc.VirtualTable;
import org.geotools.measure.Measure;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class FeatureResourceConfigurationPanel
extends ResourceConfigurationPanel {
    static final Logger LOGGER = Logging.getLogger(FeatureResourceConfigurationPanel.class);
    ModalWindow reloadWarningDialog;
    ListView attributes;
    private Fragment attributePanel;

    public FeatureResourceConfigurationPanel(String id, final IModel model) {
        super(id, model);
        CheckBox circularArcs = new CheckBox("circularArcPresent");
        this.add(new Component[]{circularArcs});
        TextField tolerance = new TextField("linearizationTolerance", Measure.class);
        this.add(new Component[]{tolerance});
        this.attributePanel = new Fragment("attributePanel", "attributePanelFragment", (MarkupContainer)this);
        this.attributePanel.setOutputMarkupId(true);
        this.add(new Component[]{this.attributePanel});
        this.attributes = new ListView("attributes", (IModel)new AttributeListModel()){

            protected void populateItem(ListItem item) {
                item.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd"))});
                AttributeTypeInfo attribute = (AttributeTypeInfo)item.getModelObject();
                item.add(new Component[]{new Label("name", attribute.getName())});
                item.add(new Component[]{new Label("minmax", attribute.getMinOccurs() + "/" + attribute.getMaxOccurs())});
                try {
                    FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
                    ResourcePool resourcePool = GeoServerApplication.get().getCatalog().getResourcePool();
                    FeatureType featureType = resourcePool.getFeatureType(typeInfo);
                    PropertyDescriptor pd = featureType.getDescriptor(attribute.getName());
                    String typeName = "?";
                    String nillable = "?";
                    try {
                        typeName = pd.getType().getBinding().getSimpleName();
                        nillable = String.valueOf(pd.isNillable());
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "Could not find attribute " + attribute.getName() + " in feature type " + featureType, e);
                    }
                    item.add(new Component[]{new Label("type", typeName)});
                    item.add(new Component[]{new Label("nillable", nillable)});
                }
                catch (IOException e) {
                    item.add(new Component[]{new Label("type", "?")});
                    item.add(new Component[]{new Label("nillable", "?")});
                }
            }
        };
        this.attributePanel.add(new Component[]{this.attributes});
        TextArea cqlFilter = new TextArea("cqlFilter");
        cqlFilter.add((IValidator)new CqlFilterValidator(model));
        this.add(new Component[]{cqlFilter});
        WebMarkupContainer reloadContainer = new WebMarkupContainer("reloadContainer");
        this.attributePanel.add(new Component[]{reloadContainer});
        GeoServerAjaxFormLink reload = new GeoServerAjaxFormLink("reload"){

            @Override
            protected void onClick(AjaxRequestTarget target, Form form) {
                GeoServerApplication app = (GeoServerApplication)this.getApplication();
                FeatureTypeInfo ft = (FeatureTypeInfo)FeatureResourceConfigurationPanel.this.getResourceInfo();
                app.getCatalog().getResourcePool().clear(ft);
                app.getCatalog().getResourcePool().clear(ft.getStore());
                target.addComponent((Component)FeatureResourceConfigurationPanel.this.attributePanel);
            }
        };
        reloadContainer.add(new Component[]{reload});
        GeoServerAjaxFormLink warning = new GeoServerAjaxFormLink("reloadWarning"){

            @Override
            protected void onClick(AjaxRequestTarget target, Form form) {
                FeatureResourceConfigurationPanel.this.reloadWarningDialog.show(target);
            }
        };
        reloadContainer.add(new Component[]{warning});
        Component[] componentArray = new Component[1];
        this.reloadWarningDialog = new ModalWindow("reloadWarningDialog");
        componentArray[0] = this.reloadWarningDialog;
        this.add(componentArray);
        this.reloadWarningDialog.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                return new ReloadWarningDialog(new StringResourceModel("featureTypeReloadWarning", (Component)FeatureResourceConfigurationPanel.this, null));
            }
        });
        this.reloadWarningDialog.setTitle((IModel)new StringResourceModel("warning", (Component)null, null));
        this.reloadWarningDialog.setInitialHeight(100);
        this.reloadWarningDialog.setInitialHeight(200);
        WebMarkupContainer sqlViewContainer = new WebMarkupContainer("editSqlContainer");
        this.attributePanel.add(new Component[]{sqlViewContainer});
        sqlViewContainer.add(new Component[]{new Link("editSql"){

            public void onClick() {
                FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
                try {
                    this.setResponsePage((Page)new SQLViewEditPage(typeInfo, (ResourceConfigurationPage)this.getPage()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failure opening the sql view edit page", e);
                    this.error((Serializable)((Object)e.toString()));
                }
            }
        }});
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
        reloadContainer.setVisible(typeInfo.getMetadata().get("JDBC_VIRTUAL_TABLE", VirtualTable.class) == null);
        sqlViewContainer.setVisible(!reloadContainer.isVisible());
        WebMarkupContainer cascadedStoredQueryContainer = new WebMarkupContainer("editCascadedStoredQueryContainer");
        this.attributePanel.add(new Component[]{cascadedStoredQueryContainer});
        cascadedStoredQueryContainer.add(new Component[]{new Link("editCascadedStoredQuery"){

            public void onClick() {
                FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
                try {
                    this.setResponsePage((Page)new CascadedWFSStoredQueryEditPage(typeInfo, (ResourceConfigurationPage)this.getPage()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failure opening the sql view edit page", e);
                    this.error((Serializable)((Object)e.toString()));
                }
            }
        }});
        cascadedStoredQueryContainer.setVisible(typeInfo.getMetadata().get("WFS_NG_STORED_QUERY_CONFIGURATION", StoredQueryConfiguration.class) != null);
    }

    @Override
    public void resourceUpdated(AjaxRequestTarget target) {
        target.addComponent((Component)this.attributePanel);
    }

    private void validateCqlFilter(FeatureTypeInfo typeInfo, String cqlFilterString) throws Exception {
        Filter cqlFilter = null;
        if (cqlFilterString != null && !cqlFilterString.isEmpty()) {
            cqlFilter = ECQL.toFilter((String)cqlFilterString);
            FeatureType ft = typeInfo.getFeatureType();
            if (ft instanceof SimpleFeatureType) {
                SimpleFeatureType sft = (SimpleFeatureType)ft;
                BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("localName");
                Collection featureAttributesNames = CollectionUtils.collect((Collection)sft.getAttributeDescriptors(), (Transformer)transformer);
                FilterAttributeExtractor filterAttriubtes = new FilterAttributeExtractor(null);
                cqlFilter.accept((FilterVisitor)filterAttriubtes, null);
                Set filterAttributesNames = filterAttriubtes.getAttributeNameSet();
                for (String filterAttributeName : filterAttributesNames) {
                    if (featureAttributesNames.contains(filterAttributeName)) continue;
                    throw new ResourceConfigurationException("CQL_ATTRIBUTE_NAME_NOT_FOUND", new Object[]{filterAttributeName});
                }
            }
        }
    }

    class AttributeListModel
    extends LoadableDetachableModel<List<AttributeTypeInfo>> {
        AttributeListModel() {
        }

        protected List<AttributeTypeInfo> load() {
            try {
                FeatureTypeInfo typeInfo = (FeatureTypeInfo)FeatureResourceConfigurationPanel.this.getDefaultModelObject();
                Catalog catalog = GeoServerApplication.get().getCatalog();
                ResourcePool resourcePool = catalog.getResourcePool();
                return resourcePool.getAttributes(typeInfo);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Grabbing the attribute list failed", e);
                String error = new ParamResourceModel("attributeListingFailed", (Component)FeatureResourceConfigurationPanel.this, e.getMessage()).getString();
                FeatureResourceConfigurationPanel.this.getPage().error((Serializable)((Object)error));
                return Collections.emptyList();
            }
        }
    }

    private class CqlFilterValidator
    implements IValidator<String> {
        private FeatureTypeInfo typeInfo;

        public CqlFilterValidator(IModel model) {
            this.typeInfo = (FeatureTypeInfo)model.getObject();
        }

        public void validate(IValidatable<String> validatable) {
            try {
                FeatureResourceConfigurationPanel.this.validateCqlFilter(this.typeInfo, (String)validatable.getValue());
            }
            catch (Exception e) {
                ValidationError error = new ValidationError();
                error.setMessage(e.getMessage());
                validatable.error((IValidationError)error);
            }
        }
    }

    static class ReloadWarningDialog
    extends WebPage {
        public ReloadWarningDialog(StringResourceModel message) {
            this.add(new Component[]{new Label("message", (IModel)message)});
        }
    }
}

