/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.web.data.resource.PeriodEditor;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.feature.type.DateUtil;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.type.PropertyDescriptor;

public class DimensionEditor
extends FormComponentPanel<DimensionInfo> {
    List<DimensionPresentation> presentationModes;
    List<DimensionDefaultValueSetting.Strategy> defaultValueStrategies;
    private CheckBox enabled;
    private DropDownChoice<String> attribute;
    private DropDownChoice<String> endAttribute;
    private DropDownChoice<DimensionPresentation> presentation;
    private DropDownChoice<DimensionDefaultValueSetting.Strategy> defaultValueStrategy;
    private TextField<String> referenceValue;
    private TextField<String> units;
    private TextField<String> unitSymbol;
    private PeriodEditor resTime;
    private TextField<BigDecimal> resElevation;
    boolean time;

    public DimensionEditor(String id, IModel<DimensionInfo> model, ResourceInfo resource, Class type) {
        super(id, model);
        final WebMarkupContainer configsContainer = new WebMarkupContainer("configContainer");
        configsContainer.setOutputMarkupId(true);
        this.add(new Component[]{configsContainer});
        final WebMarkupContainer configs = new WebMarkupContainer("configs");
        configs.setOutputMarkupId(true);
        configs.setVisible(((DimensionInfo)this.getModelObject()).isEnabled());
        configsContainer.add(new Component[]{configs});
        PropertyModel enabledModel = new PropertyModel(model, "enabled");
        this.enabled = new CheckBox("enabled", (IModel)enabledModel);
        this.add(new Component[]{this.enabled});
        this.enabled.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onclick"){

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean visile = (Boolean)DimensionEditor.this.enabled.getModelObject();
                configs.setVisible(visile.booleanValue());
                target.addComponent((Component)configsContainer);
            }
        }});
        Label noAttributeMessage = new Label("noAttributeMsg", "");
        this.add(new Component[]{noAttributeMessage});
        WebMarkupContainer attContainer = new WebMarkupContainer("attributeContainer");
        configs.add(new Component[]{attContainer});
        List<String> attributes = this.getAttributesOfType(resource, type);
        this.attribute = new DropDownChoice("attribute", (IModel)new PropertyModel(model, "attribute"), attributes);
        this.attribute.setOutputMarkupId(true);
        this.attribute.setRequired(true);
        attContainer.add(new Component[]{this.attribute});
        ArrayList<String> endAttributes = new ArrayList<String>(attributes);
        endAttributes.add(0, "-");
        this.endAttribute = new DropDownChoice("endAttribute", (IModel)new PropertyModel(model, "endAttribute"), endAttributes);
        this.endAttribute.setOutputMarkupId(true);
        this.endAttribute.setRequired(false);
        attContainer.add(new Component[]{this.endAttribute});
        if (resource instanceof FeatureTypeInfo) {
            if (attributes.isEmpty()) {
                this.disableDimension(type, configs, noAttributeMessage);
            } else {
                noAttributeMessage.setVisible(false);
            }
        } else if (resource instanceof CoverageInfo) {
            attContainer.setVisible(false);
            this.attribute.setRequired(false);
            try {
                String time;
                GridCoverageReader reader = ((CoverageInfo)resource).getGridCoverageReader(null, null);
                if (Number.class.isAssignableFrom(type)) {
                    String elev = reader.getMetadataValue("HAS_ELEVATION_DOMAIN");
                    if (!Boolean.parseBoolean(elev)) {
                        this.disableDimension(type, configs, noAttributeMessage);
                    }
                } else if (Date.class.isAssignableFrom(type) && !Boolean.parseBoolean(time = reader.getMetadataValue("HAS_TIME_DOMAIN"))) {
                    this.disableDimension(type, configs, noAttributeMessage);
                }
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        WebMarkupContainer unitsContainer = new WebMarkupContainer("unitsContainer");
        configs.add(new Component[]{unitsContainer});
        PropertyModel uModel = new PropertyModel(model, "units");
        this.units = new TextField("units", (IModel)uModel);
        unitsContainer.add(new Component[]{this.units});
        PropertyModel usModel = new PropertyModel(model, "unitSymbol");
        this.unitSymbol = new TextField("unitSymbol", (IModel)usModel);
        unitsContainer.add(new Component[]{this.unitSymbol});
        if ("elevation".equals(id) && uModel.getObject() == null) {
            uModel.setObject((Object)"EPSG:5030");
            usModel.setObject((Object)"m");
        }
        final WebMarkupContainer resContainer = new WebMarkupContainer("resolutionContainer");
        resContainer.setOutputMarkupId(true);
        configs.add(new Component[]{resContainer});
        final WebMarkupContainer resolutions = new WebMarkupContainer("resolutions");
        resolutions.setVisible(((DimensionInfo)model.getObject()).getPresentation() == DimensionPresentation.DISCRETE_INTERVAL);
        resolutions.setOutputMarkupId(true);
        resContainer.add(new Component[]{resolutions});
        this.presentationModes = new ArrayList<DimensionPresentation>(Arrays.asList(DimensionPresentation.values()));
        this.presentation = new DropDownChoice("presentation", (IModel)new PropertyModel(model, "presentation"), this.presentationModes, (IChoiceRenderer)new PresentationModeRenderer());
        configs.add(new Component[]{this.presentation});
        this.presentation.setRequired(true);
        this.presentation.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean visible = DimensionEditor.this.presentation.getModelObject() == DimensionPresentation.DISCRETE_INTERVAL;
                resolutions.setVisible(visible);
                target.addComponent((Component)resContainer);
            }
        }});
        PropertyModel rmodel = new PropertyModel(model, "resolution");
        this.resTime = new PeriodEditor("resTime", (IModel<BigDecimal>)rmodel);
        resolutions.add(new Component[]{this.resTime});
        this.resElevation = new TextField("resElevation", (IModel)rmodel);
        resolutions.add(new Component[]{this.resElevation});
        this.time = Date.class.isAssignableFrom(type);
        if (this.time) {
            this.resElevation.setVisible(false);
            this.resTime.setRequired(true);
            unitsContainer.setVisible(false);
        } else {
            this.resTime.setVisible(false);
            this.resElevation.setRequired(true);
        }
        DimensionDefaultValueSetting defValueSetting = ((DimensionInfo)model.getObject()).getDefaultValue();
        if (defValueSetting == null) {
            defValueSetting = new DimensionDefaultValueSetting();
            ((DimensionInfo)model.getObject()).setDefaultValue(defValueSetting);
        }
        final WebMarkupContainer defValueContainer = new WebMarkupContainer("defaultValueContainer");
        defValueContainer.setOutputMarkupId(true);
        configs.add(new Component[]{defValueContainer});
        final WebMarkupContainer referenceValueContainer = new WebMarkupContainer("referenceValueContainer");
        referenceValueContainer.setOutputMarkupId(true);
        referenceValueContainer.setVisible(defValueSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.FIXED || defValueSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.NEAREST);
        defValueContainer.add(new Component[]{referenceValueContainer});
        this.defaultValueStrategies = new ArrayList<DimensionDefaultValueSetting.Strategy>(Arrays.asList(DimensionDefaultValueSetting.Strategy.values()));
        PropertyModel strategyModel = new PropertyModel((Object)((DimensionInfo)model.getObject()).getDefaultValue(), "strategy");
        this.defaultValueStrategy = new DropDownChoice("strategy", (IModel)strategyModel, this.defaultValueStrategies, (IChoiceRenderer)new DefaultValueStrategyRenderer());
        configs.add(new Component[]{this.defaultValueStrategy});
        this.defaultValueStrategy.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean visible = DimensionEditor.this.defaultValueStrategy.getModelObject() == DimensionDefaultValueSetting.Strategy.FIXED || DimensionEditor.this.defaultValueStrategy.getModelObject() == DimensionDefaultValueSetting.Strategy.NEAREST;
                referenceValueContainer.setVisible(visible);
                target.addComponent((Component)defValueContainer);
            }
        }});
        defValueContainer.add(new Component[]{this.defaultValueStrategy});
        final Label refValueValidationMessage = new Label("refValueValidationMsg", "");
        refValueValidationMessage.setVisible(false);
        PropertyModel refValueModel = new PropertyModel((Object)((DimensionInfo)model.getObject()).getDefaultValue(), "referenceValue");
        this.referenceValue = new TextField("referenceValue", (IModel)refValueModel);
        this.referenceValue.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                refValueValidationMessage.setDefaultModelObject(null);
                refValueValidationMessage.setVisible(false);
                target.addComponent((Component)referenceValueContainer);
            }

            protected void onError(AjaxRequestTarget target, RuntimeException e) {
                super.onError(target, e);
                if (DimensionEditor.this.referenceValue.hasErrorMessage()) {
                    refValueValidationMessage.setDefaultModelObject((Object)DimensionEditor.this.referenceValue.getFeedbackMessage().getMessage());
                    refValueValidationMessage.setVisible(true);
                }
                target.addComponent((Component)referenceValueContainer);
            }
        }});
        this.referenceValue.add((IValidator)new ReferenceValueValidator(id, (IModel<DimensionDefaultValueSetting.Strategy>)strategyModel));
        referenceValueContainer.add(new Component[]{this.referenceValue});
        referenceValueContainer.add(new Component[]{refValueValidationMessage});
        if ("time".equals(id) && refValueModel.getObject() == null && strategyModel.getObject() == DimensionDefaultValueSetting.Strategy.NEAREST) {
            refValueModel.setObject((Object)DimensionDefaultValueSetting.TIME_CURRENT);
        }
    }

    public void disablePresentationMode(DimensionPresentation mode) {
        this.presentationModes.remove(mode);
        if (this.presentationModes.size() <= 1) {
            this.presentation.setModelObject((Object)this.presentationModes.get(0));
            this.presentation.setEnabled(false);
        }
    }

    private void disableDimension(Class type, WebMarkupContainer configs, Label noAttributeMessage) {
        this.enabled.setEnabled(false);
        this.enabled.setModelObject((Object)false);
        configs.setVisible(false);
        ParamResourceModel typeName = new ParamResourceModel("AttributeType." + type.getSimpleName(), null, new Object[0]);
        ParamResourceModel error = new ParamResourceModel("missingAttribute", (Component)this, typeName.getString());
        noAttributeMessage.setDefaultModelObject((Object)error.getString());
    }

    public boolean processChildren() {
        return true;
    }

    protected void convertInput() {
        if (!((Boolean)this.enabled.getModelObject()).booleanValue()) {
            this.setConvertedInput(new DimensionInfoImpl());
        } else {
            DimensionInfoImpl info = new DimensionInfoImpl((DimensionInfo)this.getModelObject());
            info.setEnabled(true);
            this.attribute.processInput();
            this.endAttribute.processInput();
            info.setAttribute((String)this.attribute.getModelObject());
            String endAttributeValue = (String)this.endAttribute.getModelObject();
            if ("-".equals(endAttributeValue)) {
                endAttributeValue = null;
            }
            info.setEndAttribute(endAttributeValue);
            this.units.processInput();
            String unitsValue = (String)this.units.getModelObject();
            if ("time".equals(this.getId())) {
                unitsValue = "ISO8601";
            } else if (unitsValue == null) {
                unitsValue = "";
            }
            info.setUnits(unitsValue);
            this.unitSymbol.processInput();
            info.setUnitSymbol((String)this.unitSymbol.getModelObject());
            info.setPresentation((DimensionPresentation)this.presentation.getModelObject());
            if (info.getPresentation() == DimensionPresentation.DISCRETE_INTERVAL) {
                if (this.time) {
                    this.resTime.processInput();
                    info.setResolution((BigDecimal)this.resTime.getModelObject());
                } else {
                    this.resElevation.processInput();
                    info.setResolution((BigDecimal)this.resElevation.getModelObject());
                }
            }
            DimensionDefaultValueSetting defValueSetting = new DimensionDefaultValueSetting();
            this.defaultValueStrategy.processInput();
            defValueSetting.setStrategyType((DimensionDefaultValueSetting.Strategy)this.defaultValueStrategy.getModelObject());
            if (defValueSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.FIXED || defValueSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.NEAREST) {
                this.referenceValue.processInput();
                if (this.referenceValue.hasErrorMessage()) {
                    System.out.println("About to accept erroneous value " + (String)this.referenceValue.getModelObject());
                }
                defValueSetting.setReferenceValue((String)this.referenceValue.getModelObject());
            }
            if (defValueSetting.getStrategyType() != DimensionDefaultValueSetting.Strategy.BUILTIN) {
                info.setDefaultValue(defValueSetting);
            } else {
                info.setDefaultValue(null);
            }
            this.setConvertedInput(info);
        }
    }

    List<String> getAttributesOfType(ResourceInfo resource, Class<?> type) {
        ArrayList<String> result = new ArrayList<String>();
        if (resource instanceof FeatureTypeInfo) {
            try {
                FeatureTypeInfo ft = (FeatureTypeInfo)resource;
                for (PropertyDescriptor pd : ft.getFeatureType().getDescriptors()) {
                    if (!type.isAssignableFrom(pd.getType().getBinding())) continue;
                    result.add(pd.getName().getLocalPart());
                }
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        return result;
    }

    public class ReferenceValueValidator
    extends AbstractValidator<String> {
        String dimension;
        IModel<DimensionDefaultValueSetting.Strategy> strategyModel;

        public ReferenceValueValidator(String dimensionId, IModel<DimensionDefaultValueSetting.Strategy> strategyModel) {
            this.dimension = dimensionId;
            this.strategyModel = strategyModel;
        }

        protected void onValidate(IValidatable<String> value) {
            block11: {
                if ((this.strategyModel.getObject() == DimensionDefaultValueSetting.Strategy.FIXED || this.strategyModel.getObject() == DimensionDefaultValueSetting.Strategy.NEAREST) && value.getValue() == null) {
                    this.error(value, "emptyReferenceValue");
                } else if (this.dimension.equals("time")) {
                    try {
                        DateUtil.parseDateTime((String)((String)value.getValue()));
                    }
                    catch (IllegalArgumentException iae) {
                        if (this.strategyModel.getObject() == DimensionDefaultValueSetting.Strategy.NEAREST) {
                            if (!DimensionDefaultValueSetting.TIME_CURRENT.equalsIgnoreCase((String)value.getValue())) {
                                this.error(value, "invalidNearestTimeReferenceValue", Collections.singletonMap("value", value.getValue()));
                            }
                            break block11;
                        }
                        this.error(value, "invalidTimeReferenceValue", Collections.singletonMap("value", value.getValue()));
                    }
                } else if (this.dimension.equals("elevation")) {
                    try {
                        Double.parseDouble((String)value.getValue());
                    }
                    catch (NumberFormatException nfe) {
                        this.error(value, "invalidElevationReferenceValue", Collections.singletonMap("value", value.getValue()));
                    }
                }
            }
        }

        public boolean validateOnNullValue() {
            return true;
        }
    }

    public class DefaultValueStrategyRenderer
    implements IChoiceRenderer<DimensionDefaultValueSetting.Strategy> {
        public Object getDisplayValue(DimensionDefaultValueSetting.Strategy object) {
            return new ParamResourceModel(object.name(), (Component)DimensionEditor.this, new Object[0]).getString();
        }

        public String getIdValue(DimensionDefaultValueSetting.Strategy object, int index) {
            return String.valueOf(object.ordinal());
        }
    }

    public class PresentationModeRenderer
    implements IChoiceRenderer<DimensionPresentation> {
        public Object getDisplayValue(DimensionPresentation object) {
            return new ParamResourceModel(object.name(), (Component)DimensionEditor.this, new Object[0]).getString();
        }

        public String getIdValue(DimensionPresentation object, int index) {
            return String.valueOf(object.ordinal());
        }
    }
}

