/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.data.layer.CoverageViewEditPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.data.store.panel.ColorPickerPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.util.MapModel;

public class CoverageResourceConfigurationPanel
extends ResourceConfigurationPanel {
    public CoverageResourceConfigurationPanel(String panelId, final IModel model) {
        super(panelId, model);
        CoverageInfo coverage = (CoverageInfo)this.getResourceInfo();
        Map parameters = coverage.getParameters();
        ArrayList keys = new ArrayList(parameters.keySet());
        Collections.sort(keys);
        PropertyModel paramsModel = new PropertyModel((Object)model, "parameters");
        ListView paramsList = new ListView("parameters", keys, (IModel)paramsModel){
            final /* synthetic */ IModel val$paramsModel;
            {
                this.val$paramsModel = iModel;
                super(x0, x1);
            }

            protected void populateItem(ListItem item) {
                Component inputComponent = CoverageResourceConfigurationPanel.this.getInputComponent("parameterPanel", this.val$paramsModel, item.getDefaultModelObjectAsString());
                item.add(new Component[]{inputComponent});
            }
        };
        WebMarkupContainer coverageViewContainer = new WebMarkupContainer("editCoverageViewContainer");
        this.add(new Component[]{coverageViewContainer});
        CoverageView coverageView = (CoverageView)coverage.getMetadata().get(CoverageView.COVERAGE_VIEW, CoverageView.class);
        coverageViewContainer.add(new Component[]{new Link("editCoverageView"){

            public void onClick() {
                CoverageInfo coverageInfo = (CoverageInfo)model.getObject();
                try {
                    CoverageStoreInfo store = coverageInfo.getStore();
                    WorkspaceInfo workspace = store.getWorkspace();
                    this.setResponsePage((Page)new CoverageViewEditPage(workspace.getName(), store.getName(), coverageInfo.getName(), coverageInfo, (ResourceConfigurationPage)this.getPage()));
                }
                catch (Exception e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, "Failure opening the Virtual Coverage edit page", e);
                    this.error((Serializable)((Object)e.toString()));
                }
            }
        }});
        coverageViewContainer.setVisible(coverageView != null);
        paramsList.setReuseItems(true);
        this.add(new Component[]{paramsList});
        if (keys.size() == 0) {
            this.setVisible(false);
        }
    }

    private Component getInputComponent(String id, IModel paramsModel, String keyName) {
        if (keyName.contains("Color")) {
            return new ColorPickerPanel(id, new MapModel(paramsModel, keyName), (IModel)new ResourceModel(keyName, keyName), false, new IValidator[0]);
        }
        return new TextParamPanel(id, new MapModel(paramsModel, keyName), (IModel)new ResourceModel(keyName, keyName), false, new IValidator[0]);
    }
}

