/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converters.DoubleConverter;
import org.apache.wicket.util.string.Strings;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.GeoTools;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.SampleDimensionType;

public class CoverageBandsConfigurationPanel
extends ResourceConfigurationPanel {
    static final Logger LOGGER = Logging.getLogger(CoverageBandsConfigurationPanel.class);
    private GeoServerTablePanel<CoverageDimensionInfo> bands = new GeoServerTablePanel<CoverageDimensionInfo>("bands", (GeoServerDataProvider)new CoverageDimensionsProvider(), true){

        @Override
        protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<CoverageDimensionInfo> property) {
            if ("band".equals(property.getName())) {
                Fragment f = new Fragment(id, "bandtext", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                TextField text = new TextField("bandtext", property.getModel(itemModel));
                f.add(new Component[]{text});
                return f;
            }
            if ("nullValues".equals(property.getName())) {
                Fragment f = new Fragment(id, "nulltext", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                TextField text = new TextField("nulltext", (IModel)new DoubleListModel(property.getModel(itemModel)));
                f.add(new Component[]{text});
                return f;
            }
            if ("unit".equals(property.getName())) {
                Fragment f = new Fragment(id, "text", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                Component text = CoverageBandsConfigurationPanel.this.buildUnitField("text", property.getModel(itemModel));
                f.add(new Component[]{text});
                return f;
            }
            if ("minRange".equals(property.getName())) {
                Fragment f = new Fragment(id, "minRange", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                DoubleTextField min = new DoubleTextField("minRange", (IModel<Double>)property.getModel(itemModel));
                f.add(new Component[]{min});
                return f;
            }
            if ("maxRange".equals(property.getName())) {
                Fragment f = new Fragment(id, "maxRange", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                DoubleTextField max = new DoubleTextField("maxRange", (IModel<Double>)property.getModel(itemModel));
                f.add(new Component[]{max});
                return f;
            }
            return null;
        }
    };

    public CoverageBandsConfigurationPanel(String id, IModel model) {
        super(id, model);
        this.bands.setFilterVisible(false);
        this.bands.setSortable(false);
        this.bands.getTopPager().setVisible(false);
        this.bands.getBottomPager().setVisible(false);
        this.bands.setOutputMarkupId(true);
        this.bands.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        this.bands.setFilterable(false);
        this.bands.setSelectable(false);
        this.add(new Component[]{this.bands});
        GeoServerAjaxFormLink reload = new GeoServerAjaxFormLink("reload"){

            @Override
            protected void onClick(AjaxRequestTarget target, Form form) {
                GeoServerApplication app = (GeoServerApplication)this.getApplication();
                try {
                    CoverageInfo ci = (CoverageInfo)CoverageBandsConfigurationPanel.this.getResourceInfo();
                    String nativeName = ci.getNativeCoverageName();
                    Catalog catalog = app.getCatalog();
                    CatalogBuilder cb = new CatalogBuilder(catalog);
                    cb.setStore((StoreInfo)ci.getStore());
                    MetadataMap metadata = ci.getMetadata();
                    CoverageInfo rebuilt = null;
                    if (metadata != null && metadata.containsKey((Object)CoverageView.COVERAGE_VIEW)) {
                        GridCoverage2DReader reader = (GridCoverage2DReader)catalog.getResourcePool().getGridCoverageReader(ci, nativeName, GeoTools.getDefaultHints());
                        rebuilt = cb.buildCoverage(reader, nativeName, null);
                    } else {
                        rebuilt = cb.buildCoverage(nativeName);
                    }
                    ci.getDimensions().clear();
                    ci.getDimensions().addAll(rebuilt.getDimensions());
                    target.addComponent((Component)CoverageBandsConfigurationPanel.this.bands);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failure updating the bands list", e);
                    this.error((Serializable)((Object)e.toString()));
                }
            }
        };
        this.add(new Component[]{reload});
    }

    protected Component buildUnitField(String id, IModel model) {
        return new AutoCompleteTextField<String>(id, model){

            protected Iterator<String> getChoices(String input) {
                if (Strings.isEmpty((CharSequence)input)) {
                    List emptyList = Collections.emptyList();
                    return emptyList.iterator();
                }
                ArrayList units = new ArrayList();
                units.addAll(SI.getInstance().getUnits());
                units.addAll(NonSI.getInstance().getUnits());
                ArrayList<String> unitNames = new ArrayList<String>();
                unitNames.add("W.m-2.Sr-1");
                UnitFormat format = UnitFormat.getInstance((Locale)Locale.ENGLISH);
                for (Unit unit : units) {
                    unitNames.add(format.format((Object)unit));
                }
                ArrayList<String> choices = new ArrayList<String>();
                for (String name : unitNames) {
                    if (!name.toLowerCase().startsWith(input.toLowerCase())) continue;
                    choices.add(name);
                }
                return choices.iterator();
            }
        };
    }

    class CoverageDimensionsProvider
    extends GeoServerDataProvider<CoverageDimensionInfo> {
        CoverageDimensionsProvider() {
        }

        @Override
        protected List<GeoServerDataProvider.Property<CoverageDimensionInfo>> getProperties() {
            ArrayList<GeoServerDataProvider.Property<CoverageDimensionInfo>> result = new ArrayList<GeoServerDataProvider.Property<CoverageDimensionInfo>>();
            result.add(new GeoServerDataProvider.BeanProperty("band", "name"));
            result.add(new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("dimensionType"){

                @Override
                public Object getPropertyValue(CoverageDimensionInfo item) {
                    SampleDimensionType type = item.getDimensionType();
                    if (type == null) {
                        return "-";
                    }
                    String name = type.name();
                    try {
                        String key = CoverageBandsConfigurationPanel.class.getSimpleName() + "." + name;
                        ParamResourceModel rm = new ParamResourceModel(key, null, new Object[0]);
                        return rm.getString();
                    }
                    catch (Exception e) {
                        return name;
                    }
                }
            });
            result.add(new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("nullValues"){

                @Override
                public Object getPropertyValue(CoverageDimensionInfo item) {
                    return item.getNullValues();
                }
            });
            result.add(new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("minRange"){

                @Override
                public Object getPropertyValue(final CoverageDimensionInfo item) {
                    return new IModel<Double>(){

                        public void detach() {
                        }

                        public Double getObject() {
                            if (item.getRange() == null) {
                                return null;
                            }
                            return item.getRange().getMinimum(true);
                        }

                        public void setObject(Double min) {
                            if (min != null) {
                                NumberRange range = item.getRange();
                                NumberRange newRange = NumberRange.create((double)min, (double)(range != null ? range.getMaximum() : min.doubleValue()));
                                item.setRange(newRange);
                            }
                        }
                    };
                }
            });
            result.add(new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("maxRange"){

                @Override
                public Object getPropertyValue(final CoverageDimensionInfo item) {
                    return new IModel<Double>(){

                        public void detach() {
                        }

                        public Double getObject() {
                            if (item.getRange() == null) {
                                return null;
                            }
                            return item.getRange().getMaximum();
                        }

                        public void setObject(Double max) {
                            if (max != null) {
                                NumberRange range = item.getRange();
                                NumberRange newRange = NumberRange.create((double)(range != null ? range.getMinimum() : max.doubleValue()), (double)max);
                                item.setRange(newRange);
                            }
                        }
                    };
                }
            });
            result.add(new GeoServerDataProvider.BeanProperty("unit", "unit"));
            return result;
        }

        @Override
        protected List<CoverageDimensionInfo> getItems() {
            CoverageInfo ci = (CoverageInfo)CoverageBandsConfigurationPanel.this.getDefaultModelObject();
            if (ci.getDimensions() != null) {
                return ci.getDimensions();
            }
            return Collections.emptyList();
        }
    }

    static class DoubleListModel
    implements IModel {
        private final IModel wrapped;

        public void detach() {
        }

        public DoubleListModel(IModel wrapped) {
            this.wrapped = wrapped;
        }

        public Object getObject() {
            List nullValues = (List)this.wrapped.getObject();
            if (nullValues != null && nullValues.size() > 0) {
                return ((Double)nullValues.get(0)).toString();
            }
            return "-";
        }

        public void setObject(Object object) {
            String val = (String)object;
            List vals = (List)this.wrapped.getObject();
            vals.clear();
            if (!val.equalsIgnoreCase("-")) {
                String[] values = val.contains(",") ? val.split(",") : new String[]{val.trim()};
                for (String value : values) {
                    vals.add(Double.parseDouble(value.trim()));
                }
            }
        }
    }

    static class DoubleInfinityConverter
    extends DoubleConverter {
        DoubleInfinityConverter() {
        }

        public Double convertToObject(String value, Locale locale) {
            Number number = this.parse(value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Locale.US);
            if (number == null) {
                return null;
            }
            return new Double(number.doubleValue());
        }

        public String convertToString(Object value, Locale locale) {
            return super.convertToString(value, Locale.US);
        }
    }

    static class DoubleTextField
    extends TextField<Double> {
        public DoubleTextField(String id, IModel<Double> model) {
            super(id, model, Double.class);
        }

        public IConverter getConverter(Class<?> type) {
            return new DoubleInfinityConverter();
        }
    }
}

