/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.validator.PatternValidator;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.DataLinkEditor;
import org.geoserver.web.data.resource.MetadataLinkEditor;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SRSToCRSModel;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BasicResourceConfig
extends ResourceConfigurationPanel {
    DropDownChoice projectionPolicy;
    CRSPanel declaredCRS;

    public BasicResourceConfig(String id, IModel model) {
        super(id, model);
        TextField name = new TextField("name");
        name.setRequired(true);
        this.add(new Component[]{name});
        this.add(new Component[]{new CheckBox("enabled")});
        this.add(new Component[]{new CheckBox("advertised")});
        this.add(new Component[]{new TextField("title")});
        this.add(new Component[]{new TextArea("abstract")});
        this.add(new Component[]{new KeywordsEditor("keywords", LiveCollectionModel.list((IModel)new PropertyModel((Object)model, "keywords")))});
        this.add(new Component[]{new MetadataLinkEditor("metadataLinks", (IModel<ResourceInfo>)model)});
        this.add(new Component[]{new DataLinkEditor("dataLinks", (IModel<ResourceInfo>)model)});
        Form refForm = new Form("referencingForm");
        this.add(new Component[]{refForm});
        PropertyModel nativeBBoxModel = new PropertyModel((Object)model, "nativeBoundingBox");
        EnvelopePanel nativeBBox = new EnvelopePanel("nativeBoundingBox", (IModel)nativeBBoxModel);
        nativeBBox.setOutputMarkupId(true);
        refForm.add(new Component[]{nativeBBox});
        refForm.add(new Component[]{this.computeNativeBoundsLink(refForm, nativeBBox)});
        EnvelopePanel latLonPanel = new EnvelopePanel("latLonBoundingBox", (IModel)new PropertyModel((Object)model, "latLonBoundingBox"));
        latLonPanel.setOutputMarkupId(true);
        latLonPanel.setRequired(true);
        refForm.add(new Component[]{latLonPanel});
        refForm.add(new Component[]{this.computeLatLonBoundsLink(refForm, nativeBBox, latLonPanel)});
        CRSPanel nativeCRS = new CRSPanel("nativeSRS", (IModel)new PropertyModel((Object)model, "nativeCRS"));
        nativeCRS.setReadOnly(true);
        refForm.add(new Component[]{nativeCRS});
        this.declaredCRS = new CRSPanel("declaredSRS", new SRSToCRSModel((IModel)new PropertyModel((Object)model, "sRS")));
        this.declaredCRS.setRequired(true);
        refForm.add(new Component[]{this.declaredCRS});
        this.projectionPolicy = new DropDownChoice("srsHandling", (IModel)new PropertyModel((Object)model, "projectionPolicy"), Arrays.asList(ProjectionPolicy.values()), (IChoiceRenderer)new ProjectionPolicyRenderer());
        ResourceInfo ri = (ResourceInfo)model.getObject();
        if (((ResourceInfo)model.getObject()).getCRS() == null) {
            ri.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        }
        refForm.add(new Component[]{this.projectionPolicy});
        refForm.add((IFormValidator)new ReprojectionIsPossibleValidator((FormComponent)nativeCRS, (FormComponent)this.declaredCRS, (FormComponent)this.projectionPolicy));
    }

    AjaxSubmitLink computeNativeBoundsLink(Form refForm, final EnvelopePanel nativeBBox) {
        return new AjaxSubmitLink("computeNative", refForm){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                form.process();
                ResourceInfo resource = (ResourceInfo)BasicResourceConfig.this.getDefaultModelObject();
                try {
                    CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
                    ReferencedEnvelope bounds = cb.getNativeBounds(resource);
                    resource.setNativeBoundingBox(bounds);
                    nativeBBox.setModelObject(bounds);
                }
                catch (IOException e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, "Error computing the native BBOX", e);
                    this.error((Serializable)((Object)("Error computing the native BBOX:" + e.getMessage())));
                }
                target.addComponent((Component)nativeBBox);
            }

            public boolean getDefaultFormProcessing() {
                return false;
            }
        };
    }

    GeoServerAjaxFormLink computeLatLonBoundsLink(Form refForm, final EnvelopePanel nativeBBox, final EnvelopePanel latLonPanel) {
        return new GeoServerAjaxFormLink("computeLatLon", refForm){

            @Override
            protected void onClick(AjaxRequestTarget target, Form form) {
                nativeBBox.processInput();
                BasicResourceConfig.this.declaredCRS.processInput();
                ReferencedEnvelope nativeBounds = (ReferencedEnvelope)nativeBBox.getModelObject();
                try {
                    if (nativeBounds == null) {
                        ResourceInfo resource = (ResourceInfo)BasicResourceConfig.this.getDefaultModelObject();
                        CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
                        nativeBounds = cb.getNativeBounds(resource);
                        resource.setNativeBoundingBox(nativeBounds);
                        nativeBBox.setModelObject(nativeBounds);
                        target.addComponent((Component)nativeBBox);
                    }
                    CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
                    latLonPanel.setModelObject(cb.getLatLonBounds(nativeBounds, BasicResourceConfig.this.declaredCRS.getCRS()));
                }
                catch (IOException e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, "Error computing the geographic BBOX", e);
                    this.error((Serializable)((Object)("Error computing the geographic bounds:" + e.getMessage())));
                }
                target.addComponent((Component)latLonPanel);
            }
        };
    }

    private static class ReprojectionIsPossibleValidator
    implements IFormValidator {
        private FormComponent[] dependentFormComponents;
        private FormComponent nativeCRS;
        private FormComponent declaredCRS;
        private FormComponent projectionPolicy;

        public ReprojectionIsPossibleValidator(FormComponent nativeCRS, FormComponent declaredCRS, FormComponent projectionPolicy) {
            this.nativeCRS = nativeCRS;
            this.declaredCRS = declaredCRS;
            this.projectionPolicy = projectionPolicy;
            this.dependentFormComponents = new FormComponent[]{nativeCRS, declaredCRS, projectionPolicy};
        }

        public FormComponent[] getDependentFormComponents() {
            return this.dependentFormComponents;
        }

        public void validate(Form form) {
            CoordinateReferenceSystem nativeCrs = (CoordinateReferenceSystem)this.nativeCRS.getConvertedInput();
            CoordinateReferenceSystem declaredCrs = (CoordinateReferenceSystem)this.declaredCRS.getConvertedInput();
            ProjectionPolicy policy = (ProjectionPolicy)this.projectionPolicy.getConvertedInput();
            if (policy == ProjectionPolicy.REPROJECT_TO_DECLARED) {
                boolean lenient = true;
                try {
                    CRS.findMathTransform((CoordinateReferenceSystem)nativeCrs, (CoordinateReferenceSystem)declaredCrs, (boolean)true);
                }
                catch (FactoryException e) {
                    String msgKey = "BasicResourceConfig.noTransformFromNativeToDeclaredCRS";
                    String errMsg = e.getMessage();
                    String message = new ResourceModel(msgKey).getObject();
                    form.error(message, Collections.singletonMap("error", errMsg));
                }
            }
        }
    }

    static class ResourceNameValidator
    extends PatternValidator {
        public ResourceNameValidator() {
            super("[\\w][\\w.-]*");
        }
    }

    class ProjectionPolicyRenderer
    implements IChoiceRenderer {
        ProjectionPolicyRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((ProjectionPolicy)object).name(), (Component)BasicResourceConfig.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((ProjectionPolicy)object).name();
        }
    }
}

