/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public abstract class StyleListPanel
extends GeoServerTablePanel<StyleInfo> {
    private static final long serialVersionUID = -811883647153309626L;
    static GeoServerDataProvider.Property<StyleInfo> NAME = new GeoServerDataProvider.BeanProperty<StyleInfo>("name", "name");

    public StyleListPanel(String id, StyleListProvider styleProvider) {
        super(id, styleProvider);
        this.getTopPager().setVisible(false);
    }

    public StyleListPanel(String id) {
        this(id, new StyleListProvider());
    }

    @Override
    protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<StyleInfo> property) {
        final StyleInfo style = (StyleInfo)itemModel.getObject();
        if (property == NAME) {
            return new SimpleAjaxLink(id, NAME.getModel(itemModel)){

                @Override
                public void onClick(AjaxRequestTarget target) {
                    StyleListPanel.this.handleStyle(style, target);
                }
            };
        }
        return null;
    }

    protected abstract void handleStyle(StyleInfo var1, AjaxRequestTarget var2);

    protected static class StyleListProvider
    extends GeoServerDataProvider<StyleInfo> {
        protected StyleListProvider() {
        }

        @Override
        protected List<StyleInfo> getItems() {
            return this.getCatalog().getStyles();
        }

        @Override
        protected List<GeoServerDataProvider.Property<StyleInfo>> getProperties() {
            return Arrays.asList(NAME);
        }

        @Override
        public IModel newModel(Object object) {
            return new StyleDetachableModel((StyleInfo)object);
        }
    }
}

