/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layergroup.LayerListPanel;
import org.geoserver.web.wicket.ParamResourceModel;

public class RootLayerEntryPanel
extends Panel {
    public RootLayerEntryPanel(String id, final Form form, WorkspaceInfo workspace) {
        super(id);
        this.setOutputMarkupId(true);
        TextField<LayerInfo> rootLayerField = new TextField<LayerInfo>("rootLayer"){

            public IConverter getConverter(Class<?> type) {
                return form.getConverter(type);
            }
        };
        rootLayerField.setOutputMarkupId(true);
        rootLayerField.setRequired(true);
        this.add(new Component[]{rootLayerField});
        ArrayList<StyleInfo> globalStyles = new ArrayList<StyleInfo>();
        List allStyles = GeoServerApplication.get().getCatalog().getStyles();
        for (StyleInfo s : allStyles) {
            if (s.getWorkspace() != null) continue;
            globalStyles.add(s);
        }
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        styles.addAll(globalStyles);
        if (workspace != null) {
            styles.addAll(GeoServerApplication.get().getCatalog().getStylesByWorkspace(workspace));
        }
        DropDownChoice<StyleInfo> styleField = new DropDownChoice<StyleInfo>("rootLayerStyle", styles){

            public IConverter getConverter(Class<?> type) {
                return form.getConverter(type);
            }
        };
        styleField.setNullValid(true);
        this.add(new Component[]{styleField});
        final ModalWindow popupWindow = new ModalWindow("popup");
        this.add(new Component[]{popupWindow});
        this.add(new Component[]{new AjaxLink("add", (TextField)rootLayerField){
            final /* synthetic */ TextField val$rootLayerField;
            {
                this.val$rootLayerField = textField;
                super(x0);
            }

            public void onClick(AjaxRequestTarget target) {
                popupWindow.setInitialHeight(375);
                popupWindow.setInitialWidth(525);
                popupWindow.setTitle((IModel)new ParamResourceModel("chooseLayer", (Component)this, new Object[0]));
                popupWindow.setContent((Component)new LayerListPanel(popupWindow.getContentId()){

                    @Override
                    protected void handleLayer(LayerInfo layer, AjaxRequestTarget target) {
                        popupWindow.close(target);
                        ((LayerGroupInfo)form.getModelObject()).setRootLayer(layer);
                        target.addComponent((Component)val$rootLayerField);
                    }
                });
                popupWindow.show(target);
            }
        }});
    }
}

