/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.web.data.layer.LayerDetachableModel;
import org.geoserver.web.data.layer.LayerProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public abstract class LayerListPanel
extends GeoServerTablePanel<LayerInfo> {
    private static final long serialVersionUID = 3638205114048153057L;
    static GeoServerDataProvider.Property<LayerInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerInfo>("name", "name");
    static GeoServerDataProvider.Property<LayerInfo> STORE = new GeoServerDataProvider.BeanProperty<LayerInfo>("store", "resource.store.name");
    static GeoServerDataProvider.Property<LayerInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<LayerInfo>("workspace", "resource.store.workspace.name");

    public LayerListPanel(String id) {
        this(id, new LayerListProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<LayerInfo> iterator(int first, int count) {
                Iterator<LayerInfo> iterator = this.filteredItems(first, count);
                if (iterator instanceof CloseableIterator) {
                    try {
                        Iterator<LayerInfo> iterator2 = Lists.newArrayList(iterator).iterator();
                        return iterator2;
                    }
                    finally {
                        CloseableIteratorAdapter.close(iterator);
                    }
                }
                return iterator;
            }

            private Iterator<LayerInfo> filteredItems(Integer first, Integer count) {
                Catalog catalog = this.getCatalog();
                SortParam sort = this.getSort();
                GeoServerDataProvider.Property property = this.getProperty(sort);
                SortBy sortOrder = null;
                if (sort != null && property instanceof GeoServerDataProvider.BeanProperty) {
                    String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
                    sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
                }
                Filter filter = this.getFilter();
                CloseableIterator items = catalog.list(LayerInfo.class, filter, first, count, sortOrder);
                return items;
            }
        });
    }

    protected LayerListPanel(String id, GeoServerDataProvider<LayerInfo> provider) {
        super(id, provider);
        this.getTopPager().setVisible(false);
    }

    @Override
    protected Component getComponentForProperty(String id, final IModel itemModel, GeoServerDataProvider.Property<LayerInfo> property) {
        IModel model = property.getModel(itemModel);
        if (NAME == property) {
            return new SimpleAjaxLink(id, model){

                @Override
                protected void onClick(AjaxRequestTarget target) {
                    LayerInfo layer = (LayerInfo)itemModel.getObject();
                    LayerListPanel.this.handleLayer(layer, target);
                }
            };
        }
        return new Label(id, model);
    }

    protected void handleLayer(LayerInfo layer, AjaxRequestTarget target) {
    }

    protected static abstract class LayerListProvider
    extends LayerProvider {
        protected LayerListProvider() {
        }

        @Override
        protected List<GeoServerDataProvider.Property<LayerInfo>> getProperties() {
            return Arrays.asList(NAME, STORE, WORKSPACE);
        }

        @Override
        public IModel newModel(Object object) {
            return new LayerDetachableModel((LayerInfo)object);
        }
    }
}

