/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.web.data.layergroup.LayerGroupDetachableModel;
import org.geoserver.web.data.layergroup.LayerGroupProviderFilter;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class LayerGroupProvider
extends GeoServerDataProvider<LayerGroupInfo> {
    public static GeoServerDataProvider.Property<LayerGroupInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("name", "name");
    public static GeoServerDataProvider.Property<LayerGroupInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("workspace", "workspace.name");
    static List PROPERTIES = Arrays.asList(NAME, WORKSPACE);
    protected LayerGroupProviderFilter groupFilter = null;

    public LayerGroupProvider() {
    }

    public LayerGroupProvider(LayerGroupProviderFilter groupFilter) {
        this.groupFilter = groupFilter;
    }

    @Override
    protected List<LayerGroupInfo> getItems() {
        ArrayList<LayerGroupInfo> groups = this.getCatalog().getLayerGroups();
        if (this.groupFilter != null) {
            ArrayList<LayerGroupInfo> filtered = new ArrayList<LayerGroupInfo>(groups.size());
            for (LayerGroupInfo group : groups) {
                if (!this.groupFilter.accept(group)) continue;
                filtered.add(group);
            }
            groups = filtered;
        }
        return groups;
    }

    @Override
    protected List<GeoServerDataProvider.Property<LayerGroupInfo>> getProperties() {
        return PROPERTIES;
    }

    @Override
    public IModel newModel(Object object) {
        return new LayerGroupDetachableModel((LayerGroupInfo)object);
    }
}

