/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.SelectionRemovalLink;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.layergroup.LayerGroupNewPage;
import org.geoserver.web.data.layergroup.LayerGroupProvider;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;

public class LayerGroupPage
extends GeoServerSecuredPage {
    GeoServerTablePanel<LayerGroupInfo> table;
    GeoServerDialog dialog;
    SelectionRemovalLink removal;

    public LayerGroupPage() {
        LayerGroupProvider provider = new LayerGroupProvider();
        Component[] componentArray = new Component[1];
        this.table = new GeoServerTablePanel<LayerGroupInfo>("table", (GeoServerDataProvider)provider, true){

            @Override
            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<LayerGroupInfo> property) {
                if (property == LayerGroupProvider.NAME) {
                    return LayerGroupPage.this.layerGroupLink(id, itemModel);
                }
                if (property == LayerGroupProvider.WORKSPACE) {
                    return LayerGroupPage.this.workspaceLink(id, itemModel);
                }
                return null;
            }

            @Override
            protected void onSelectionUpdate(AjaxRequestTarget target) {
                if (!LayerGroupPage.this.table.getSelection().isEmpty()) {
                    boolean canRemove = true;
                    if (!LayerGroupPage.this.isAuthenticatedAsAdmin()) {
                        for (LayerGroupInfo lg : LayerGroupPage.this.table.getSelection()) {
                            if (lg.getWorkspace() != null) continue;
                            canRemove = false;
                            break;
                        }
                    }
                    LayerGroupPage.this.removal.setEnabled(canRemove);
                } else {
                    LayerGroupPage.this.removal.setEnabled(false);
                }
                target.addComponent((Component)LayerGroupPage.this.removal);
            }
        };
        componentArray[0] = this.table;
        this.add(componentArray);
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", LayerGroupNewPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    Component layerGroupLink(String id, IModel itemModel) {
        IModel groupNameModel = LayerGroupProvider.NAME.getModel(itemModel);
        IModel wsModel = LayerGroupProvider.WORKSPACE.getModel(itemModel);
        String groupName = (String)groupNameModel.getObject();
        String wsName = (String)wsModel.getObject();
        return new SimpleBookmarkableLink(id, LayerGroupEditPage.class, groupNameModel, "group", groupName, "workspace", wsName);
    }

    Component workspaceLink(String id, IModel itemModel) {
        IModel wsNameModel = LayerGroupProvider.WORKSPACE.getModel(itemModel);
        String wsName = (String)wsNameModel.getObject();
        if (wsName != null) {
            return new SimpleBookmarkableLink(id, WorkspaceEditPage.class, (IModel)new Model((Serializable)((Object)wsName)), "name", wsName);
        }
        return new WebMarkupContainer(id);
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

