/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.data.layergroup.LayerGroupEntry;
import org.geoserver.web.data.layergroup.LayerGroupListPanel;
import org.geoserver.web.data.layergroup.LayerListPanel;
import org.geoserver.web.data.layergroup.StyleListPanel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.ReorderableTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geoserver.web.wicket.UpDownPanel;

public class LayerGroupEntryPanel
extends Panel {
    public static GeoServerDataProvider.Property<LayerGroupEntry> LAYER = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("layer");
    public static GeoServerDataProvider.Property<LayerGroupEntry> DEFAULT_STYLE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("defaultStyle");
    public static GeoServerDataProvider.Property<LayerGroupEntry> STYLE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("style");
    public static GeoServerDataProvider.Property<LayerGroupEntry> REMOVE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("remove");
    static List PROPERTIES = Arrays.asList(LAYER, DEFAULT_STYLE, STYLE, REMOVE);
    ModalWindow popupWindow;
    GeoServerTablePanel<LayerGroupEntry> layerTable;
    List<LayerGroupEntry> items = new ArrayList<LayerGroupEntry>();
    GeoServerDialog dialog;

    public LayerGroupEntryPanel(String id, LayerGroupInfo layerGroup) {
        super(id);
        for (int i = 0; i < layerGroup.getLayers().size(); ++i) {
            PublishedInfo layer = (PublishedInfo)layerGroup.getLayers().get(i);
            StyleInfo style = (StyleInfo)layerGroup.getStyles().get(i);
            this.items.add(new LayerGroupEntry(layer, style));
        }
        Component[] componentArray = new Component[1];
        this.popupWindow = new ModalWindow("popup");
        componentArray[0] = this.popupWindow;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.add(new Component[]{new HelpLink("layersHelp").setDialog(this.dialog)});
        Component[] componentArray3 = new Component[1];
        this.layerTable = new ReorderableTablePanel<LayerGroupEntry>("layers", this.items, PROPERTIES){

            @Override
            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<LayerGroupEntry> property) {
                if (property == LAYER) {
                    return LayerGroupEntryPanel.this.layerLink(id, itemModel);
                }
                if (property == DEFAULT_STYLE) {
                    return LayerGroupEntryPanel.this.defaultStyleCheckbox(id, itemModel);
                }
                if (property == STYLE) {
                    return LayerGroupEntryPanel.this.styleLink(id, itemModel);
                }
                if (property == REMOVE) {
                    return LayerGroupEntryPanel.this.removeLink(id, itemModel);
                }
                return null;
            }
        }.setFilterable(false);
        componentArray3[0] = this.layerTable;
        this.add(componentArray3);
        this.layerTable.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
        this.layerTable.setOutputMarkupId(true);
        this.add(new Component[]{new AjaxLink("addLayer"){

            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseLayer", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new LayerListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId()){

                    @Override
                    protected void handleLayer(LayerInfo layer, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close(target);
                        LayerGroupEntryPanel.this.items.add(new LayerGroupEntry((PublishedInfo)layer, layer.getDefaultStyle()));
                        target.addComponent(LayerGroupEntryPanel.this.layerTable);
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show(target);
            }
        }});
        this.add(new Component[]{new AjaxLink("addLayerGroup"){

            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseLayerGroup", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new LayerGroupListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId()){

                    @Override
                    protected void handleLayerGroup(LayerGroupInfo layerGroup, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close(target);
                        LayerGroupEntryPanel.this.items.add(new LayerGroupEntry((PublishedInfo)layerGroup, null));
                        target.addComponent(LayerGroupEntryPanel.this.layerTable);
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show(target);
            }
        }});
    }

    public List<LayerGroupEntry> getEntries() {
        return this.items;
    }

    Component layerLink(String id, IModel itemModel) {
        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        return new Label(id, entry.getLayer().prefixedName());
    }

    Component defaultStyleCheckbox(String id, IModel itemModel) {
        final LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        Fragment f = new Fragment(id, "defaultStyle", (MarkupContainer)this);
        CheckBox ds = new CheckBox("checkbox", (IModel)new Model((Serializable)Boolean.valueOf(entry.isDefaultStyle())));
        ds.add(new IBehavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean useDefault = (Boolean)this.getComponent().getDefaultModelObject();
                entry.setDefaultStyle(useDefault);
                target.addComponent(LayerGroupEntryPanel.this.layerTable);
            }
        }});
        f.add(new Component[]{ds});
        return f;
    }

    Component styleLink(String id, final IModel itemModel) {
        LayerInfo layer;
        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        String styleName = null;
        boolean defaultStyle = true;
        if (entry.getStyle() != null) {
            styleName = entry.getStyle().getName();
            defaultStyle = false;
        } else if (entry.getLayer() instanceof LayerInfo && (layer = (LayerInfo)entry.getLayer()).getDefaultStyle() != null) {
            styleName = layer.getDefaultStyle().getName();
        }
        SimpleAjaxLink link = new SimpleAjaxLink(id, (IModel)new Model((Serializable)((Object)styleName))){

            @Override
            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseStyle", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new StyleListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId()){

                    @Override
                    protected void handleStyle(StyleInfo style, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close(target);
                        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
                        entry.setStyle(style);
                        target.addComponent(LayerGroupEntryPanel.this.layerTable);
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show(target);
            }
        };
        link.getLink().setEnabled(!defaultStyle);
        return link;
    }

    Component removeLink(String id, IModel itemModel) {
        final LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        ImageAjaxLink link = new ImageAjaxLink(id, new ResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/delete.png")){

            @Override
            protected void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.items.remove(entry);
                target.addComponent(LayerGroupEntryPanel.this.layerTable);
            }
        };
        link.getImage().add(new IBehavior[]{new AttributeModifier("alt", true, (IModel)new ParamResourceModel("AbstractLayerGroupPage.th.remove", (Component)link, new Object[0]))});
        return link;
    }

    Component positionPanel(String id, IModel itemModel) {
        ParamResourceModel upTitle = new ParamResourceModel("moveToBottom", (Component)this, new Object[0]);
        ParamResourceModel downTitle = new ParamResourceModel("moveToBottom", (Component)this, new Object[0]);
        return new UpDownPanel<LayerGroupEntry>(id, (LayerGroupEntry)itemModel.getObject(), this.items, (Component)this.layerTable, upTitle, downTitle);
    }
}

