/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.GeoServerApplication;

public class LayerGroupEntry
implements Serializable {
    String styleId;
    String layerId;
    String layerGroupId;

    public LayerGroupEntry(PublishedInfo layer, StyleInfo style) {
        this.setLayer(layer);
        this.setStyle(style);
    }

    public StyleInfo getStyle() {
        if (this.styleId == null) {
            return null;
        }
        return GeoServerApplication.get().getCatalog().getStyle(this.styleId);
    }

    public boolean isDefaultStyle() {
        return this.styleId == null;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        if (defaultStyle || this.getLayer() instanceof LayerGroupInfo) {
            this.setStyle(null);
        } else {
            this.setStyle(((LayerInfo)this.getLayer()).getDefaultStyle());
        }
    }

    public void setStyle(StyleInfo style) {
        this.styleId = style == null ? null : style.getId();
    }

    public PublishedInfo getLayer() {
        if (this.layerGroupId != null) {
            return GeoServerApplication.get().getCatalog().getLayerGroup(this.layerGroupId);
        }
        return GeoServerApplication.get().getCatalog().getLayer(this.layerId);
    }

    public void setLayer(PublishedInfo publishedInfo) {
        if (publishedInfo instanceof LayerGroupInfo) {
            this.layerGroupId = publishedInfo.getId();
        } else {
            this.layerId = publishedInfo.getId();
        }
    }
}

