/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layer.Parameter;
import org.geoserver.web.data.layer.SQLViewAttribute;
import org.geoserver.web.data.layer.SQLViewAttributeProvider;
import org.geoserver.web.data.layer.SQLViewParamProvider;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.data.DataAccess;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.VirtualTable;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class SQLViewAbstractPage
extends GeoServerSecuredPage {
    public static final String DATASTORE = "storeName";
    public static final String WORKSPACE = "wsName";
    String storeId;
    String typeInfoId;
    String sql;
    String name;
    boolean newView;
    SQLViewAttributeProvider attProvider;
    private TextArea sqlEditor;
    private GeoServerTablePanel<SQLViewAttribute> attributes;
    private GeoServerTablePanel<Parameter> parameters;
    private SQLViewParamProvider paramProvider;
    boolean guessGeometrySrid = false;
    private CheckBox guessCheckbox;
    private boolean escapeSql = true;
    private static final List GEOMETRY_TYPES = Arrays.asList(Geometry.class, GeometryCollection.class, Point.class, MultiPoint.class, LineString.class, MultiLineString.class, Polygon.class, MultiPolygon.class);

    public SQLViewAbstractPage(PageParameters params) throws IOException {
        this(params.getString(WORKSPACE), params.getString(DATASTORE), null, null);
    }

    public SQLViewAbstractPage(String workspaceName, String storeName, String typeName, VirtualTable virtualTable) throws IOException {
        this.storeId = ((DataStoreInfo)this.getCatalog().getStoreByName(workspaceName, storeName, DataStoreInfo.class)).getId();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this));
        this.add(new Component[]{form});
        TextField nameField = new TextField("name");
        nameField.setRequired(true);
        nameField.add((IValidator)new ViewNameValidator());
        form.add(new Component[]{nameField});
        this.sqlEditor = new TextArea("sql");
        form.add(new Component[]{this.sqlEditor});
        this.attProvider = new SQLViewAttributeProvider();
        this.paramProvider = new SQLViewParamProvider();
        if (typeName != null) {
            this.newView = false;
            DataStoreInfo store = (DataStoreInfo)this.getCatalog().getStore(this.storeId, DataStoreInfo.class);
            FeatureTypeInfo fti = (FeatureTypeInfo)this.getCatalog().getResourceByStore((StoreInfo)store, typeName, FeatureTypeInfo.class);
            if (fti != null) {
                this.typeInfoId = fti.getId();
            }
            if (virtualTable == null) {
                throw new IllegalArgumentException("The specified feature type does not have a sql view attached to it");
            }
            DataAccess da = store.getDataStore(null);
            if (!(da instanceof JDBCDataStore)) {
                this.error((Serializable)((Object)"Cannot create a SQL view if the store is not database based"));
                this.doReturn(StorePage.class);
                return;
            }
            this.name = virtualTable.getName();
            this.sql = virtualTable.getSql();
            this.escapeSql = virtualTable.isEscapeSql();
            this.paramProvider.init(virtualTable);
            try {
                SimpleFeatureType ft = this.testViewDefinition(virtualTable, false);
                this.attProvider.setFeatureType(ft, virtualTable);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to build feature type for the sql view", e);
            }
        } else {
            this.newView = true;
        }
        form.add(new Component[]{new GeoServerAjaxFormLink("guessParams"){

            @Override
            protected void onClick(AjaxRequestTarget target, Form form) {
                SQLViewAbstractPage.this.sqlEditor.processInput();
                SQLViewAbstractPage.this.parameters.processInputs();
                if (SQLViewAbstractPage.this.sql != null && !"".equals(SQLViewAbstractPage.this.sql.trim())) {
                    SQLViewAbstractPage.this.paramProvider.refreshFromSql(SQLViewAbstractPage.this.sql);
                    target.addComponent((Component)SQLViewAbstractPage.this.parameters);
                }
            }
        }});
        form.add(new Component[]{new GeoServerAjaxFormLink("addNewParam"){

            @Override
            protected void onClick(AjaxRequestTarget target, Form form) {
                SQLViewAbstractPage.this.paramProvider.addParameter();
                target.addComponent((Component)SQLViewAbstractPage.this.parameters);
            }
        }});
        form.add(new Component[]{new GeoServerAjaxFormLink("removeParam"){

            @Override
            protected void onClick(AjaxRequestTarget target, Form form) {
                SQLViewAbstractPage.this.paramProvider.removeAll(SQLViewAbstractPage.this.parameters.getSelection());
                SQLViewAbstractPage.this.parameters.clearSelection();
                target.addComponent((Component)SQLViewAbstractPage.this.parameters);
            }
        }});
        this.parameters = new GeoServerTablePanel<Parameter>("parameters", (GeoServerDataProvider)this.paramProvider, true){

            @Override
            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<Parameter> property) {
                Fragment f = new Fragment(id, "text", (MarkupContainer)SQLViewAbstractPage.this);
                TextField text = new TextField("text", property.getModel(itemModel));
                text.setLabel((IModel)new ParamResourceModel("th." + property.getName(), (Component)SQLViewAbstractPage.this, new Object[0]));
                if (property == SQLViewParamProvider.NAME) {
                    text.setRequired(true);
                } else if (property == SQLViewParamProvider.REGEXP) {
                    text.add((IValidator)new RegexpValidator());
                }
                f.add(new Component[]{text});
                return f;
            }
        };
        this.parameters.setFilterVisible(false);
        this.parameters.setSortable(false);
        this.parameters.getTopPager().setVisible(false);
        this.parameters.getBottomPager().setVisible(false);
        this.parameters.setOutputMarkupId(true);
        form.add(new Component[]{this.parameters});
        form.add(new Component[]{this.refreshLink()});
        Component[] componentArray = new Component[1];
        this.guessCheckbox = new CheckBox("guessGeometrySrid", (IModel)new PropertyModel((Object)this, "guessGeometrySrid"));
        componentArray[0] = this.guessCheckbox;
        form.add(componentArray);
        form.add(new Component[]{new CheckBox("escapeSql")});
        this.attributes = new GeoServerTablePanel<SQLViewAttribute>("attributes", (GeoServerDataProvider)this.attProvider){

            @Override
            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<SQLViewAttribute> property) {
                boolean isGeometry;
                SQLViewAttribute att = (SQLViewAttribute)itemModel.getObject();
                boolean bl = isGeometry = att.getType() != null && Geometry.class.isAssignableFrom(att.getType());
                if (property == SQLViewAttributeProvider.PK) {
                    Fragment f = new Fragment(id, "checkbox", (MarkupContainer)SQLViewAbstractPage.this);
                    f.add(new Component[]{new CheckBox("identifier", (IModel)new PropertyModel((Object)itemModel, "pk"))});
                    return f;
                }
                if (property == SQLViewAttributeProvider.TYPE && isGeometry) {
                    Fragment f = new Fragment(id, "geometry", (MarkupContainer)SQLViewAbstractPage.this);
                    f.add(new Component[]{new DropDownChoice("geometry", (IModel)new PropertyModel((Object)itemModel, "type"), GEOMETRY_TYPES, (IChoiceRenderer)new GeometryTypeRenderer())});
                    return f;
                }
                if (property == SQLViewAttributeProvider.SRID && isGeometry) {
                    Fragment f = new Fragment(id, "text", (MarkupContainer)SQLViewAbstractPage.this);
                    f.add(new Component[]{new TextField("text", (IModel)new PropertyModel((Object)itemModel, "srid"))});
                    return f;
                }
                return null;
            }
        };
        this.attributes.setFilterVisible(false);
        this.attributes.setSortable(false);
        this.attributes.setPageable(false);
        this.attributes.setOutputMarkupId(true);
        form.add(new Component[]{this.attributes});
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                SQLViewAbstractPage.this.onSave();
            }
        }});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                SQLViewAbstractPage.this.onCancel();
            }
        }});
    }

    private GeoServerAjaxFormLink refreshLink() {
        return new GeoServerAjaxFormLink("refresh"){

            @Override
            protected void onClick(AjaxRequestTarget target, Form form) {
                SQLViewAbstractPage.this.sqlEditor.processInput();
                SQLViewAbstractPage.this.parameters.processInputs();
                SQLViewAbstractPage.this.guessCheckbox.processInput();
                if (SQLViewAbstractPage.this.sql != null && !"".equals(SQLViewAbstractPage.this.sql.trim())) {
                    SimpleFeatureType newSchema = null;
                    try {
                        newSchema = SQLViewAbstractPage.this.testViewDefinition(SQLViewAbstractPage.this.guessGeometrySrid);
                        if (newSchema != null) {
                            SQLViewAbstractPage.this.attProvider.setFeatureType(newSchema, null);
                            target.addComponent((Component)SQLViewAbstractPage.this.attributes);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.INFO, "Error testing SQL query", e);
                        this.error((Serializable)((Object)SQLViewAbstractPage.this.getFirstErrorMessage(e)));
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeatureType testViewDefinition(boolean guessGeometrySrid) throws IOException {
        JDBCDataStore ds = (JDBCDataStore)this.getCatalog().getDataStore(this.storeId).getDataStore(null);
        String vtName = null;
        try {
            do {
                vtName = UUID.randomUUID().toString();
            } while (Arrays.asList(ds.getTypeNames()).contains(vtName));
            VirtualTable vt = new VirtualTable(vtName, this.sql);
            this.paramProvider.updateVirtualTable(vt);
            ds.addVirtualTable(vt);
            SimpleFeatureType simpleFeatureType = this.guessFeatureType(ds, vt.getName(), guessGeometrySrid);
            return simpleFeatureType;
        }
        finally {
            if (vtName != null) {
                ds.removeVirtualTable(vtName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeatureType getFeatureType(VirtualTable vt) throws IOException {
        JDBCDataStore ds = (JDBCDataStore)this.getCatalog().getDataStore(this.storeId).getDataStore(null);
        String vtName = null;
        try {
            do {
                vtName = UUID.randomUUID().toString();
            } while (Arrays.asList(ds.getTypeNames()).contains(vtName));
            ds.addVirtualTable(new VirtualTable(vtName, vt));
            SimpleFeatureType simpleFeatureType = ds.getSchema(vtName);
            return simpleFeatureType;
        }
        finally {
            if (vtName != null) {
                ds.removeVirtualTable(vtName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeatureType testViewDefinition(VirtualTable virtualTable, boolean guessGeometrySrid) throws IOException {
        JDBCDataStore ds = (JDBCDataStore)this.getCatalog().getDataStore(this.storeId).getDataStore(null);
        String vtName = null;
        try {
            do {
                vtName = UUID.randomUUID().toString();
            } while (Arrays.asList(ds.getTypeNames()).contains(vtName));
            VirtualTable vt = new VirtualTable(vtName, virtualTable);
            vt.setPrimaryKeyColumns(Collections.EMPTY_LIST);
            vt.setEscapeSql(this.escapeSql);
            ds.addVirtualTable(vt);
            SimpleFeatureType simpleFeatureType = this.guessFeatureType(ds, vt.getName(), guessGeometrySrid);
            return simpleFeatureType;
        }
        finally {
            if (vtName != null) {
                ds.removeVirtualTable(this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleFeatureType guessFeatureType(JDBCDataStore store, String vtName, boolean guessGeometrySrid) throws IOException {
        SimpleFeatureType base = store.getSchema(vtName);
        ArrayList<String> geometries = new ArrayList<String>();
        for (AttributeDescriptor ad : base.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor)) continue;
            geometries.add(ad.getLocalName());
        }
        if (geometries.size() == 0 || !guessGeometrySrid) {
            return base;
        }
        Query q = new Query(vtName);
        q.setPropertyNames(geometries);
        q.setMaxFeatures(1);
        SimpleFeature f = null;
        try (SimpleFeatureIterator it = null;){
            it = store.getFeatureSource(vtName).getFeatures(q).features();
            if (it.hasNext()) {
                f = (SimpleFeature)it.next();
            }
        }
        if (f == null) {
            return base;
        }
        Connection cx = null;
        try {
            store.getConnection(Transaction.AUTO_COMMIT);
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setName(base.getName());
            for (AttributeDescriptor ad : base.getAttributeDescriptors()) {
                if (ad instanceof GeometryDescriptor) {
                    GeometryDescriptor gd = (GeometryDescriptor)ad;
                    Geometry g = (Geometry)f.getAttribute(ad.getLocalName());
                    if (g == null) {
                        tb.add(ad);
                        continue;
                    }
                    Class<?> binding = g.getClass();
                    CoordinateReferenceSystem crs = null;
                    if (g.getSRID() > 0) {
                        crs = store.getSQLDialect().createCRS(g.getSRID(), cx);
                        tb.userData((Object)"nativeSRID", (Object)g.getSRID());
                    }
                    if (crs == null) {
                        crs = gd.getCoordinateReferenceSystem();
                    }
                    tb.add(ad.getLocalName(), binding, crs);
                    continue;
                }
                tb.add(ad);
            }
            SimpleFeatureType simpleFeatureType = tb.buildFeatureType();
            return simpleFeatureType;
        }
        catch (SQLException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            store.closeSafe(cx);
        }
    }

    protected VirtualTable buildVirtualTable() {
        VirtualTable vt = new VirtualTable(this.name, this.sql);
        this.attProvider.fillVirtualTable(vt);
        this.paramProvider.updateVirtualTable(vt);
        return vt;
    }

    protected String getFirstErrorMessage(Throwable t) {
        Throwable original = t;
        while (!(t instanceof SQLException) && (t = t.getCause()) != null) {
        }
        if (t == null) {
            return original.getMessage();
        }
        return t.getMessage();
    }

    protected abstract void onSave();

    protected abstract void onCancel();

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    class ViewNameValidator
    extends AbstractValidator {
        ViewNameValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            String vtName = (String)validatable.getValue();
            DataStoreInfo store = (DataStoreInfo)SQLViewAbstractPage.this.getCatalog().getStore(SQLViewAbstractPage.this.storeId, DataStoreInfo.class);
            List ftis = SQLViewAbstractPage.this.getCatalog().getResourcesByStore((StoreInfo)store, FeatureTypeInfo.class);
            for (FeatureTypeInfo curr : ftis) {
                VirtualTable currvt = (VirtualTable)curr.getMetadata().get("JDBC_VIRTUAL_TABLE", VirtualTable.class);
                if (currvt == null || SQLViewAbstractPage.this.typeInfoId != null && SQLViewAbstractPage.this.typeInfoId.equals(curr.getId()) || !currvt.getName().equals(vtName)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", vtName);
                map.put("typeName", curr.getName());
                this.error(validatable, "duplicateSqlViewName", map);
                return;
            }
        }
    }

    static class RegexpValidator
    extends AbstractValidator {
        RegexpValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            String value = (String)validatable.getValue();
            if (value != null) {
                try {
                    Pattern.compile(value);
                }
                catch (PatternSyntaxException e) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("regexp", value);
                    map.put("error", e.getMessage().replaceAll("\\^?", ""));
                    this.error(validatable, "invalidRegexp", map);
                }
            }
        }
    }

    static class GeometryTypeRenderer
    implements IChoiceRenderer {
        GeometryTypeRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return ((Class)object).getSimpleName();
        }

        public String getIdValue(Object object, int index) {
            return (String)this.getDisplayValue(object);
        }
    }
}

