/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.data.layer.CoverageViewAbstractPage;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class CoverageViewNewPage
extends CoverageViewAbstractPage {
    public CoverageViewNewPage(PageParameters params) throws IOException {
        this(params.getString("wsName"), params.getString("storeName"), null, null);
    }

    public CoverageViewNewPage(String workspaceName, String storeName, String coverageName, CoverageInfo coverageInfo) throws IOException {
        super(workspaceName, storeName, coverageName, coverageInfo);
    }

    @Override
    protected void onSave() {
        try {
            if (this.name.equalsIgnoreCase("COVERAGEVIEW_NAME")) {
                throw new IllegalArgumentException("Make sure to specify a proper coverage name, different that COVERAGEVIEW_NAME");
            }
            Catalog catalog = this.getCatalog();
            CatalogBuilder builder = new CatalogBuilder(catalog);
            CoverageStoreInfo coverageStoreInfo = catalog.getCoverageStore(this.storeId);
            CoverageInfo coverageInfo = null;
            CoverageView coverageView = this.buildCoverageView();
            List coverageBands = coverageView.getCoverageBands();
            if (coverageBands == null || coverageBands.isEmpty()) {
                throw new IllegalArgumentException("No output bands have been specified ");
            }
            coverageInfo = coverageView.createCoverageInfo(this.name, coverageStoreInfo, builder);
            LayerInfo layerInfo = builder.buildLayer(coverageInfo);
            this.setResponsePage((Page)new ResourceConfigurationPage(layerInfo, true));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to create Coverage View", e);
            this.error((Serializable)((Object)new ParamResourceModel("creationFailure", (Component)this, this.getFirstErrorMessage(e)).getString()));
        }
    }

    @Override
    protected void onCancel() {
        this.doReturn(LayerPage.class);
    }
}

