/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.web.data.layer.CoverageViewAbstractPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class CoverageViewEditPage
extends CoverageViewAbstractPage {
    private CoverageInfo coverageInfo;
    private ResourceConfigurationPage previousPage;

    public CoverageViewEditPage(String workspaceName, String storeName, String coverageName, CoverageInfo coverageInfo, ResourceConfigurationPage previusPage) throws IOException {
        super(workspaceName, storeName, coverageName, coverageInfo);
        this.previousPage = previusPage;
        this.coverageInfo = coverageInfo;
    }

    @Override
    protected void onSave() {
        try {
            Catalog catalog = this.getCatalog();
            CatalogBuilder builder = new CatalogBuilder(catalog);
            CoverageStoreInfo coverageStoreInfo = catalog.getCoverageStore(this.storeId);
            CoverageView coverageView = this.buildCoverageView();
            List coverageBands = coverageView.getCoverageBands();
            if (coverageBands == null || coverageBands.isEmpty()) {
                throw new IllegalArgumentException("No output bands have been specified ");
            }
            coverageView.updateCoverageInfo(this.name, coverageStoreInfo, builder, this.coverageInfo);
            this.previousPage.updateResource((ResourceInfo)this.coverageInfo);
            this.setResponsePage((Page)this.previousPage);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to create feature type", e);
            this.error((Serializable)((Object)new ParamResourceModel("creationFailure", (Component)this, this.getFirstErrorMessage(e)).getString()));
        }
    }

    @Override
    protected void onCancel() {
        this.setResponsePage((Page)this.previousPage);
    }
}

