/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.awt.image.SampleModel;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.ImageLayout;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layer.CoverageViewEditor;
import org.geotools.coverage.grid.io.GridCoverage2DReader;

public abstract class CoverageViewAbstractPage
extends GeoServerSecuredPage {
    public static final String COVERAGESTORE = "storeName";
    public static final String WORKSPACE = "wsName";
    static final String COVERAGE_VIEW_NAME = "COVERAGEVIEW_NAME";
    String storeId;
    String coverageInfoId;
    String definition;
    String name;
    boolean newCoverage;
    CoverageInfo coverageViewInfo;
    List<String> availableCoverages;
    List<String> selectedCoverages;
    List<CoverageView.CoverageBand> outputBands;
    CoverageViewEditor coverageEditor;

    public CoverageViewAbstractPage(PageParameters params) throws IOException {
        this(params.getString(WORKSPACE), params.getString(COVERAGESTORE), null, null);
    }

    public CoverageViewAbstractPage(String workspaceName, String storeName, String coverageName, CoverageInfo coverageInfo) throws IOException {
        this.storeId = ((CoverageStoreInfo)this.getCatalog().getStoreByName(workspaceName, storeName, CoverageStoreInfo.class)).getId();
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo store = (CoverageStoreInfo)catalog.getStore(this.storeId, CoverageStoreInfo.class);
        GridCoverage2DReader reader = (GridCoverage2DReader)catalog.getResourcePool().getGridCoverageReader(store, null);
        String[] coverageNames = reader.getGridCoverageNames();
        if (this.availableCoverages == null) {
            this.availableCoverages = new ArrayList<String>();
        }
        for (String coverage : coverageNames) {
            ImageLayout layout = reader.getImageLayout(coverage);
            SampleModel sampleModel = layout.getSampleModel(null);
            int numBands = sampleModel.getNumBands();
            for (int i = 0; i < numBands; ++i) {
                this.availableCoverages.add(coverage + "@" + i);
            }
        }
        Collections.sort(this.availableCoverages);
        this.name = COVERAGE_VIEW_NAME;
        if (coverageName != null) {
            this.newCoverage = false;
            this.coverageViewInfo = coverageInfo != null ? coverageInfo : (CoverageInfo)catalog.getResourceByStore((StoreInfo)store, coverageName, CoverageInfo.class);
            CoverageView coverageView = (CoverageView)this.coverageViewInfo.getMetadata().get(CoverageView.COVERAGE_VIEW, CoverageView.class);
            if (this.coverageViewInfo != null) {
                this.coverageInfoId = this.coverageViewInfo.getId();
            }
            if (coverageView == null) {
                throw new IllegalArgumentException("The specified coverage does not have a coverage view attached to it");
            }
            this.outputBands = new ArrayList<CoverageView.CoverageBand>(coverageView.getCoverageBands());
            this.name = coverageView.getName();
        } else {
            this.outputBands = new ArrayList<CoverageView.CoverageBand>();
            this.newCoverage = true;
            this.coverageViewInfo = null;
        }
        this.selectedCoverages = new ArrayList<String>(this.availableCoverages);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this));
        this.add(new Component[]{form});
        TextField nameField = new TextField("name");
        nameField.setRequired(true);
        nameField.add((IValidator)new CoverageViewNameValidator());
        form.add(new Component[]{nameField});
        this.coverageEditor = new CoverageViewEditor("coverages", (IModel)new PropertyModel((Object)this, "selectedCoverages"), (IModel)new PropertyModel((Object)this, "outputBands"), this.availableCoverages);
        form.add(new Component[]{this.coverageEditor});
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                CoverageViewAbstractPage.this.onSave();
            }
        }});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                CoverageViewAbstractPage.this.onCancel();
            }
        }});
    }

    protected CoverageView buildCoverageView() throws IOException {
        return new CoverageView(this.name, this.coverageEditor.currentOutputBands);
    }

    protected String getFirstErrorMessage(Throwable t) {
        Throwable original = t;
        while (!(t instanceof SQLException) && (t = t.getCause()) != null) {
        }
        if (t == null) {
            return original.getMessage();
        }
        return t.getMessage();
    }

    protected abstract void onSave();

    protected abstract void onCancel();

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    public List<String> getSelectedCoverages() {
        return this.selectedCoverages;
    }

    public void setSelectedCoverages(List<String> selectedCoverages) {
        this.selectedCoverages = selectedCoverages;
    }

    private class CompositionTypeRenderer
    implements IChoiceRenderer {
        public Object getDisplayValue(Object object) {
            return object.toString();
        }

        public String getIdValue(Object object, int index) {
            return object.toString();
        }
    }

    class CoverageViewNameValidator
    extends AbstractValidator {
        CoverageViewNameValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            String vcName = (String)validatable.getValue();
            CoverageStoreInfo store = (CoverageStoreInfo)CoverageViewAbstractPage.this.getCatalog().getStore(CoverageViewAbstractPage.this.storeId, CoverageStoreInfo.class);
            List coverages = CoverageViewAbstractPage.this.getCatalog().getCoveragesByCoverageStore(store);
            for (CoverageInfo curr : coverages) {
                CoverageView currvc = (CoverageView)curr.getMetadata().get(CoverageView.COVERAGE_VIEW, CoverageView.class);
                if (currvc == null || CoverageViewAbstractPage.this.coverageInfoId != null && CoverageViewAbstractPage.this.coverageInfoId.equals(curr.getId()) || !currvc.getName().equals(vcName) || !CoverageViewAbstractPage.this.newCoverage) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", vcName);
                map.put("coverageName", curr.getName());
                this.error(validatable, "duplicateCoverageViewName", map);
                return;
            }
        }
    }
}

