/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import net.opengis.wfs20.ParameterExpressionType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.panel.Fragment;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.web.data.layer.CascadedWFSStoredQueryAbstractPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMapping;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingBlockValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingDefaultValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingExpressionValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.StoredQueryConfiguration;

public class CascadedWFSStoredQueryEditPage
extends CascadedWFSStoredQueryAbstractPage {
    private ResourceConfigurationPage previousPage;
    private FeatureTypeInfo editableType;
    private StoredQueryConfiguration configuration;
    private String storedQueryId;

    public CascadedWFSStoredQueryEditPage(FeatureTypeInfo type, ResourceConfigurationPage previousPage) throws IOException {
        super(type.getStore().getWorkspace().getName(), type.getStore().getName(), type.getName());
        this.editableType = type;
        this.configuration = (StoredQueryConfiguration)type.getMetadata().get((Object)"WFS_NG_STORED_QUERY_CONFIGURATION");
        this.storedQueryId = this.configuration.getStoredQueryId();
        this.previousPage = previousPage;
        this.parameterProvider.refreshItems(this.configuration.getStoredQueryId());
    }

    @Override
    public void populateStoredQueryParameterAttribute(String storedQueryId, ParameterExpressionType pet, CascadedWFSStoredQueryAbstractPage.StoredQueryParameterAttribute attr) {
        if (!storedQueryId.equals(this.configuration.getStoredQueryId())) {
            throw new RuntimeException("Programming error! Stored query ids do not match: '" + storedQueryId + "' vs '" + this.configuration.getStoredQueryId() + "'");
        }
        ParameterMapping mapping = null;
        if (this.configuration.getStoredQueryParameterMappings() != null) {
            for (ParameterMapping pm : this.configuration.getStoredQueryParameterMappings()) {
                if (!pm.getParameterName().equals(pet.getName())) continue;
                mapping = pm;
                break;
            }
        }
        if (mapping == null) {
            attr.setMappingType(CascadedWFSStoredQueryAbstractPage.ParameterMappingType.NONE);
            attr.setValue(null);
        } else {
            ParameterMappingExpressionValue pmev;
            CascadedWFSStoredQueryAbstractPage.ParameterMappingType type = CascadedWFSStoredQueryAbstractPage.ParameterMappingType.NONE;
            String value = null;
            if (mapping instanceof ParameterMappingBlockValue) {
                type = CascadedWFSStoredQueryAbstractPage.ParameterMappingType.BLOCKED;
            } else if (mapping instanceof ParameterMappingDefaultValue) {
                ParameterMappingDefaultValue pmdv = (ParameterMappingDefaultValue)mapping;
                type = pmdv.isForcible() ? CascadedWFSStoredQueryAbstractPage.ParameterMappingType.STATIC : CascadedWFSStoredQueryAbstractPage.ParameterMappingType.DEFAULT;
                value = pmdv.getDefaultValue();
            } else if (mapping instanceof ParameterMappingExpressionValue && (pmev = (ParameterMappingExpressionValue)mapping).getExpressionLanguage().equals("CQL")) {
                type = CascadedWFSStoredQueryAbstractPage.ParameterMappingType.EXPRESSION_CQL;
                value = pmev.getExpression();
            }
            attr.setMappingType(type);
            attr.setValue(value);
        }
    }

    @Override
    protected Component getStoredQueryNameComponent() {
        return new Fragment("storedQueryName", "editPage", (MarkupContainer)this);
    }

    @Override
    protected void onSave() {
        StoredQueryConfiguration config = CascadedWFSStoredQueryEditPage.createStoredQueryConfiguration(this.parameterProvider.getItems(), this.storedQueryId);
        this.editableType.getMetadata().put("WFS_NG_STORED_QUERY_CONFIGURATION", (Serializable)config);
        this.setResponsePage((Page)this.previousPage);
    }

    @Override
    protected void onCancel() {
        this.setResponsePage((Page)this.previousPage);
    }
}

