/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.jai.util.CacheDiagnostics;
import java.awt.GraphicsEnvironment;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.web.admin.JVMFontsPage;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.LockingManager;
import org.opengis.filter.Filter;

public class StatusPage
extends ServerAdminPage {
    private final Map<String, String> values = new HashMap<String, String>();
    private static final String KEY_DATA_DIR = "dataDir";
    private static final String KEY_LOCKS = "locks";
    private static final String KEY_CONNECTIONS = "connections";
    private static final String KEY_MEMORY = "memory";
    private static final String KEY_JVM_VERSION = "jvm_version";
    private static final String KEY_JAI_AVAILABLE = "jai_available";
    private static final String KEY_JAI_IMAGEIO_AVAILABLE = "jai_imageio_available";
    private static final String KEY_JAI_MAX_MEM = "jai_max_mem";
    private static final String KEY_JAI_MEM_USAGE = "jai_mem_usage";
    private static final String KEY_JAI_MEM_THRESHOLD = "jai_mem_threshold";
    private static final String KEY_JAI_TILE_THREADS = "jai_tile_threads";
    private static final String KEY_JAI_TILE_THREAD_PRIORITY = "jai_tile_thread_priority";
    private static final String KEY_COVERAGEACCESS_CORE_POOL_SIZE = "coverage_thread_corepoolsize";
    private static final String KEY_COVERAGEACCESS_MAX_POOL_SIZE = "coverage_thread_maxpoolsize";
    private static final String KEY_COVERAGEACCESS_KEEP_ALIVE_TIME = "coverage_thread_keepalivetime";
    private static final String KEY_UPDATE_SEQUENCE = "update_sequence";

    public StatusPage() {
        this.updateModel();
        this.add(new Component[]{new Label(KEY_DATA_DIR, (IModel)new MapModel(this.values, KEY_DATA_DIR))});
        this.add(new Component[]{new Label(KEY_LOCKS, (IModel)new MapModel(this.values, KEY_LOCKS))});
        this.add(new Component[]{new Label(KEY_CONNECTIONS, (IModel)new MapModel(this.values, KEY_CONNECTIONS))});
        this.add(new Component[]{new Label(KEY_MEMORY, (IModel)new MapModel(this.values, KEY_MEMORY))});
        this.add(new Component[]{new Label("jvm.version", (IModel)new MapModel(this.values, KEY_JVM_VERSION))});
        this.add(new Component[]{new Label("jai.available", (IModel)new MapModel(this.values, KEY_JAI_AVAILABLE))});
        this.add(new Component[]{new Label("jai.imageio.available", (IModel)new MapModel(this.values, KEY_JAI_IMAGEIO_AVAILABLE))});
        this.add(new Component[]{new Label("jai.memory.available", (IModel)new MapModel(this.values, KEY_JAI_MAX_MEM))});
        this.add(new Component[]{new Label("jai.memory.used", (IModel)new MapModel(this.values, KEY_JAI_MEM_USAGE))});
        this.add(new Component[]{new Label("jai.memory.threshold", (IModel)new MapModel(this.values, KEY_JAI_MEM_THRESHOLD))});
        this.add(new Component[]{new Label("jai.tile.threads", (IModel)new MapModel(this.values, KEY_JAI_TILE_THREADS))});
        this.add(new Component[]{new Label("jai.tile.priority", (IModel)new MapModel(this.values, KEY_JAI_TILE_THREAD_PRIORITY))});
        this.add(new Component[]{new Label("coverage.corepoolsize", (IModel)new MapModel(this.values, KEY_COVERAGEACCESS_CORE_POOL_SIZE))});
        this.add(new Component[]{new Label("coverage.maxpoolsize", (IModel)new MapModel(this.values, KEY_COVERAGEACCESS_MAX_POOL_SIZE))});
        this.add(new Component[]{new Label("coverage.keepalivetime", (IModel)new MapModel(this.values, KEY_COVERAGEACCESS_KEEP_ALIVE_TIME))});
        this.add(new Component[]{new Label("updateSequence", (IModel)new MapModel(this.values, KEY_UPDATE_SEQUENCE))});
        this.add(new Component[]{new Link("free.locks"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                StatusPage.this.updateModel();
            }
        }});
        this.add(new Component[]{new Link("free.memory"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                System.gc();
                System.runFinalization();
                StatusPage.this.updateModel();
            }
        }});
        this.add(new Component[]{new Link("free.memory.jai"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                TileCache jaiCache = StatusPage.this.getGeoServer().getGlobal().getJAI().getTileCache();
                long capacityBefore = jaiCache.getMemoryCapacity();
                jaiCache.flush();
                jaiCache.setMemoryCapacity(0L);
                System.gc();
                System.runFinalization();
                jaiCache.setMemoryCapacity(capacityBefore);
                StatusPage.this.updateModel();
            }
        }});
        int fontCount = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts().length;
        this.add(new Component[]{new Label("fontCount", (IModel)new ParamResourceModel("StatusPage.fontCount", (Component)this, fontCount))});
        this.add(new Component[]{new BookmarkablePageLink("show.fonts", JVMFontsPage.class)});
        this.add(new Component[]{new AjaxLink("clear.resourceCache"){

            public void onClick(AjaxRequestTarget target) {
                try {
                    StatusPage.this.getGeoServer().reset();
                    this.info(this.getLocalizer().getString("resourceCacheClearedSuccessfully", (Component)this));
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "Error resetting resource caches", t);
                    this.error(t);
                }
                target.addComponent((Component)StatusPage.this.feedbackPanel);
            }
        }});
        this.add(new Component[]{new AjaxLink("reload.catalogConfig"){

            public void onClick(AjaxRequestTarget target) {
                try {
                    StatusPage.this.getGeoServer().reload();
                    this.info(this.getLocalizer().getString("catalogConfigReloadedSuccessfully", (Component)StatusPage.this));
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "An error occurred while reloading the catalog", t);
                    this.error(t);
                }
                target.addComponent((Component)StatusPage.this.feedbackPanel);
            }
        }});
    }

    private void updateModel() {
        this.values.put(KEY_DATA_DIR, this.getDataDirectory());
        this.values.put(KEY_LOCKS, Long.toString(this.getLockCount()));
        this.values.put(KEY_CONNECTIONS, Long.toString(this.getConnectionCount()));
        this.values.put(KEY_MEMORY, this.formatUsedMemory());
        this.values.put(KEY_JVM_VERSION, System.getProperty("java.vendor") + ": " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + ")");
        this.values.put(KEY_JAI_AVAILABLE, Boolean.toString(this.isNativeJAIAvailable()));
        this.values.put(KEY_JAI_IMAGEIO_AVAILABLE, Boolean.toString(PackageUtil.isCodecLibAvailable()));
        GeoServerInfo geoServerInfo = this.getGeoServer().getGlobal();
        JAIInfo jaiInfo = geoServerInfo.getJAI();
        JAI jai = jaiInfo.getJAI();
        CoverageAccessInfo coverageAccess = geoServerInfo.getCoverageAccess();
        TileCache jaiCache = jaiInfo.getTileCache();
        this.values.put(KEY_JAI_MAX_MEM, this.formatMemory(jaiCache.getMemoryCapacity()));
        if (jaiCache instanceof CacheDiagnostics) {
            this.values.put(KEY_JAI_MEM_USAGE, this.formatMemory(((CacheDiagnostics)jaiCache).getCacheMemoryUsed()));
        } else {
            this.values.put(KEY_JAI_MEM_USAGE, "-");
        }
        this.values.put(KEY_JAI_MEM_THRESHOLD, Float.toString(100.0f * jaiCache.getMemoryThreshold()));
        this.values.put(KEY_JAI_TILE_THREADS, Integer.toString(jai.getTileScheduler().getParallelism()));
        this.values.put(KEY_JAI_TILE_THREAD_PRIORITY, Integer.toString(jai.getTileScheduler().getPriority()));
        this.values.put(KEY_COVERAGEACCESS_CORE_POOL_SIZE, Integer.toString(coverageAccess.getCorePoolSize()));
        this.values.put(KEY_COVERAGEACCESS_MAX_POOL_SIZE, Integer.toString(coverageAccess.getMaxPoolSize()));
        this.values.put(KEY_COVERAGEACCESS_KEEP_ALIVE_TIME, Integer.toString(coverageAccess.getKeepAliveTime()));
        this.values.put(KEY_UPDATE_SEQUENCE, Long.toString(geoServerInfo.getUpdateSequence()));
    }

    private String getDataDirectory() {
        GeoServerDataDirectory dd = this.getGeoServerApplication().getBeanOfType(GeoServerDataDirectory.class);
        return dd.root().getAbsolutePath();
    }

    boolean isNativeJAIAvailable() {
        try {
            Class<?> image = Class.forName("com.sun.medialib.mlib.Image");
            return (Boolean)image.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private String formatUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        long usedBytes = runtime.totalMemory() - runtime.freeMemory();
        String formattedUsedMemory = this.formatMemory(usedBytes);
        return formattedUsedMemory;
    }

    private String formatMemory(long bytes) {
        long KB = 1024L;
        long MB = 0x100000L;
        long GB = 0x40000000L;
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(2);
        String formattedUsedMemory = bytes > 0x40000000L ? formatter.format(bytes / 0x40000000L) + " GB" : (bytes > 0x100000L ? formatter.format(bytes / 0x100000L) + " MB" : formatter.format(bytes / 1024L) + " KB");
        return formattedUsedMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getLockCount() {
        int count;
        block8: {
            count = 0;
            CloseableIterator<DataStoreInfo> i = this.getDataStores();
            block6: while (true) {
                while (i.hasNext()) {
                    DataStoreInfo meta = (DataStoreInfo)i.next();
                    if (!meta.isEnabled()) continue;
                    try {
                        LockingManager lockingManager;
                        DataAccess store = meta.getDataStore(null);
                        if (store instanceof DataStore && (lockingManager = ((DataStore)store).getLockingManager()) == null) continue block6;
                    }
                    catch (IllegalStateException notAvailable) {
                    }
                    catch (Throwable huh) {
                    }
                }
                break block8;
                {
                    continue block6;
                    break;
                }
                break;
            }
            finally {
                i.close();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getConnectionCount() {
        int count = 0;
        try (CloseableIterator<DataStoreInfo> i = this.getDataStores();){
            while (i.hasNext()) {
                DataStoreInfo meta = (DataStoreInfo)i.next();
                if (!meta.isEnabled()) continue;
                try {
                    meta.getDataStore(null);
                }
                catch (Throwable notAvailable) {
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    private CloseableIterator<DataStoreInfo> getDataStores() {
        Catalog catalog = this.getGeoServer().getCatalog();
        Filter filter = Predicates.acceptAll();
        CloseableIterator stores = catalog.list(DataStoreInfo.class, filter);
        return stores;
    }
}

