/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.NumberValidator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIEXTInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.web.admin.JAIEXTPanel;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.image.ImageWorker;

public class JAIPage
extends ServerAdminPage {
    private static final long serialVersionUID = -1184717232184497578L;

    public JAIPage() {
        final IModel geoServerModel = this.getGeoServerModel();
        final IModel<JAIInfo> jaiModel = this.getJAIModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel(jaiModel));
        this.add(new Component[]{form});
        NumberValidator percentageValidator = NumberValidator.range((long)0L, (long)1L);
        TextField memoryCapacity = new TextField("memoryCapacity");
        memoryCapacity.add((IValidator)percentageValidator);
        form.add(new Component[]{memoryCapacity});
        TextField memoryThreshold = new TextField("memoryThreshold");
        memoryThreshold.add((IValidator)percentageValidator);
        form.add(new Component[]{memoryThreshold});
        TextField tileThreads = new TextField("tileThreads");
        tileThreads.add((IValidator)NumberValidator.POSITIVE);
        form.add(new Component[]{tileThreads});
        TextField tilePriority = new TextField("tilePriority");
        tilePriority.add((IValidator)NumberValidator.POSITIVE);
        form.add(new Component[]{tilePriority});
        form.add(new Component[]{new CheckBox("recycling")});
        form.add(new Component[]{new CheckBox("jpegAcceleration")});
        this.addPngEncoderEditor(form);
        CheckBox checkBoxMosaic = new CheckBox("allowNativeMosaic");
        CheckBox checkBoxWarp = new CheckBox("allowNativeWarp");
        JAIInfo info = (JAIInfo)jaiModel.getObject();
        JAIEXTInfo je = null;
        boolean isJAIExtEnabled = ImageWorker.isJaiExtEnabled();
        if (isJAIExtEnabled) {
            je = info.getJAIEXTInfo();
        }
        boolean mosaicEnabled = je != null && !je.getJAIEXTOperations().contains("Mosaic");
        boolean warpEnabled = je != null && !je.getJAIEXTOperations().contains("Warp");
        checkBoxMosaic.setEnabled(mosaicEnabled);
        checkBoxWarp.setEnabled(warpEnabled);
        form.add(new Component[]{checkBoxMosaic});
        form.add(new Component[]{checkBoxWarp});
        JAIEXTPanel jaiExtPanel = new JAIEXTPanel("jaiext", jaiModel);
        if (!isJAIExtEnabled) {
            jaiExtPanel.setVisible(false);
        }
        form.add(new Component[]{jaiExtPanel});
        Button submit = new Button("submit", (IModel)new StringResourceModel("submit", (Component)this, null)){

            public void onSubmit() {
                GeoServer gs = (GeoServer)geoServerModel.getObject();
                GeoServerInfo global = gs.getGlobal();
                global.setJAI((JAIInfo)jaiModel.getObject());
                gs.save(global);
                JAIPage.this.doReturn();
            }
        };
        form.add(new Component[]{submit});
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                JAIPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    private void addPngEncoderEditor(Form form) {
        ArrayList<JAIInfo.PngEncoderType> encoders = new ArrayList<JAIInfo.PngEncoderType>(Arrays.asList(JAIInfo.PngEncoderType.values()));
        if (!PackageUtil.isCodecLibAvailable()) {
            encoders.remove(JAIInfo.PngEncoderType.NATIVE);
        }
        DropDownChoice editor = new DropDownChoice("pngEncoderType", encoders, (IChoiceRenderer)new IChoiceRenderer<JAIInfo.PngEncoderType>(){

            public Object getDisplayValue(JAIInfo.PngEncoderType type) {
                return new ParamResourceModel("pngEncoder." + type.name(), (Component)JAIPage.this, new Object[0]).getString();
            }

            public String getIdValue(JAIInfo.PngEncoderType type, int index) {
                return type.name();
            }
        });
        form.add(new Component[]{editor});
        if (!encoders.contains(editor.getModelObject())) {
            editor.setModelObject((Object)JAIInfo.PngEncoderType.PNGJ);
        }
    }
}

