/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.web.AdminComponentAuthorizer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class WorkspaceAdminComponentAuthorizer
extends AdminComponentAuthorizer {
    @Override
    public boolean isAccessAllowed(Class componentClass, Authentication authentication) {
        if (super.isAccessAllowed(componentClass, authentication)) {
            return true;
        }
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }
        List<String> roles = this.lookupWorkspaceAdminRoles();
        for (GrantedAuthority auth : authentication.getAuthorities()) {
            if (!roles.contains(auth.getAuthority())) continue;
            return true;
        }
        return false;
    }

    List<String> lookupWorkspaceAdminRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        DataAccessRuleDAO dao = DataAccessRuleDAO.get();
        for (DataAccessRule rule : dao.getRules()) {
            if (rule.getAccessMode() != AccessMode.ADMIN) continue;
            roles.addAll(rule.getRoles());
        }
        return roles;
    }
}

