/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.WicketCallback;

public class WicketConfigurationLockCallback
implements WicketCallback {
    GeoServerConfigurationLock locker;
    static ThreadLocal<GeoServerConfigurationLock.LockType> THREAD_LOCK = new ThreadLocal();

    public WicketConfigurationLockCallback(GeoServerConfigurationLock locker) {
        this.locker = locker;
    }

    @Override
    public void onBeginRequest() {
    }

    @Override
    public void onAfterTargetsDetached() {
    }

    @Override
    public void onEndRequest() {
        GeoServerConfigurationLock.LockType type = THREAD_LOCK.get();
        if (type != null) {
            THREAD_LOCK.remove();
            this.locker.unlock(type);
        }
    }

    @Override
    public void onRequestTargetSet(IRequestTarget target) {
        IBookmarkablePageRequestTarget bt;
        GeoServerConfigurationLock.LockType type = THREAD_LOCK.get();
        if (type != null) {
            return;
        }
        if (target instanceof IPageRequestTarget) {
            IPageRequestTarget pt = (IPageRequestTarget)target;
            Page page = pt.getPage();
            if (page instanceof GeoServerSecuredPage) {
                type = GeoServerConfigurationLock.LockType.WRITE;
            }
        } else if (target instanceof IBookmarkablePageRequestTarget && GeoServerSecuredPage.class.isAssignableFrom((bt = (IBookmarkablePageRequestTarget)target).getPageClass())) {
            type = GeoServerConfigurationLock.LockType.WRITE;
        }
        if (type == null) {
            type = GeoServerConfigurationLock.LockType.READ;
        }
        THREAD_LOCK.set(type);
        this.locker.lock(type);
    }

    @Override
    public void onRuntimeException(Page page, RuntimeException e) {
    }
}

