/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.web.ComponentInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.ToolLinkExternalInfo;
import org.geoserver.web.ToolLinkInfo;

public class ToolPage
extends GeoServerSecuredPage {
    public ToolPage() {
        List<ToolLinkInfo> links = this.getGeoServerApplication().getBeansOfType(ToolLinkInfo.class);
        links.addAll(this.getGeoServerApplication().getBeansOfType(ToolLinkExternalInfo.class));
        links = this.filterByAuth(links);
        this.add(new Component[]{new ListView("toolList", links){

            public void populateItem(ListItem item) {
                ComponentInfo info = (ComponentInfo)item.getModelObject();
                BookmarkablePageLink link = null;
                if (info instanceof ToolLinkInfo) {
                    ToolLinkInfo tool = (ToolLinkInfo)info;
                    link = new BookmarkablePageLink("theLink", tool.getComponentClass());
                } else {
                    ToolLinkExternalInfo tool = (ToolLinkExternalInfo)info;
                    link = new ExternalLink("theLink", tool.getHref());
                }
                link.add(new Component[]{new Label("theTitle", (IModel)new StringResourceModel(info.getTitleKey(), (Component)null, null))});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("theDescription", (IModel)new StringResourceModel(info.getDescriptionKey(), (Component)null, null))});
            }
        }});
    }
}

