/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.request.CryptedUrlWebRequestCodingStrategy;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;

public class GeoServerRequestEncodingStrategy
implements IRequestCodingStrategy {
    WebRequestCodingStrategy strategy = new WebRequestCodingStrategy();
    CryptedUrlWebRequestCodingStrategy cryptedStrategy = new CryptedUrlWebRequestCodingStrategy((IRequestCodingStrategy)this.strategy);
    GeoServerSecurityManager manager = (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);

    public void mount(IRequestTargetUrlCodingStrategy urlCodingStrategy) {
        if (this.manager.isEncryptingUrlParams()) {
            this.cryptedStrategy.mount(urlCodingStrategy);
        } else {
            this.strategy.mount(urlCodingStrategy);
        }
    }

    public void addIgnoreMountPath(String path) {
        if (this.manager.isEncryptingUrlParams()) {
            this.cryptedStrategy.addIgnoreMountPath(path);
        } else {
            this.strategy.addIgnoreMountPath(path);
        }
    }

    public CharSequence pathForTarget(IRequestTarget requestTarget) {
        if (this.manager.isEncryptingUrlParams()) {
            return this.cryptedStrategy.pathForTarget(requestTarget);
        }
        return this.strategy.pathForTarget(requestTarget);
    }

    public IRequestTarget targetForRequest(RequestParameters requestParameters) {
        if (this.manager.isEncryptingUrlParams()) {
            return this.cryptedStrategy.targetForRequest(requestParameters);
        }
        return this.strategy.targetForRequest(requestParameters);
    }

    public void unmount(String path) {
        if (this.manager.isEncryptingUrlParams()) {
            this.cryptedStrategy.unmount(path);
        } else {
            this.strategy.unmount(path);
        }
    }

    public IRequestTargetUrlCodingStrategy urlCodingStrategyForPath(String path) {
        if (this.manager.isEncryptingUrlParams()) {
            return this.cryptedStrategy.urlCodingStrategyForPath(path);
        }
        return this.strategy.urlCodingStrategyForPath(path);
    }

    public RequestParameters decode(Request request) {
        if (this.manager.isEncryptingUrlParams()) {
            return this.cryptedStrategy.decode(request);
        }
        return this.strategy.decode(request);
    }

    public CharSequence encode(RequestCycle requestCycle, IRequestTarget requestTarget) {
        if (this.manager.isEncryptingUrlParams()) {
            return this.cryptedStrategy.encode(requestCycle, requestTarget);
        }
        return this.strategy.encode(requestCycle, requestTarget);
    }

    public String rewriteStaticRelativeUrl(String string) {
        if (this.manager.isEncryptingUrlParams()) {
            return this.cryptedStrategy.rewriteStaticRelativeUrl(string);
        }
        return this.strategy.rewriteStaticRelativeUrl(string);
    }
}

