/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerNodeInfo;
import org.geoserver.web.spring.security.GeoServerSession;
import org.geotools.util.logging.Logging;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;

public class DefaultGeoServerNodeInfo
implements GeoServerNodeInfo {
    static final String GEOSERVER_NODE_OPTS = "GEOSERVER_NODE_OPTS";
    static final Logger LOGGER = Logging.getLogger(DefaultGeoServerNodeInfo.class);
    static String NODE_ID;
    static String NODE_ID_STYLE;
    static final String DEFAULT_NODE_ID_TEMPLATE = "position:absolute; top:12px; left:12px; right:28px; width:auto; background:$background; padding: 1px; border: 1px solid #0076a1; color:$color; font-weight:bold";

    protected static void initializeFromEnviroment() {
        String property = GeoServerExtensions.getProperty((String)GEOSERVER_NODE_OPTS);
        if (property == null) {
            NODE_ID = null;
            NODE_ID_STYLE = null;
        } else {
            try {
                Map<String, String> options = DefaultGeoServerNodeInfo.parseProperties(property);
                String id = options.get("id");
                if (id != null) {
                    InetAddress address;
                    if (id.contains("$host_ip")) {
                        address = DefaultGeoServerNodeInfo.getLocalHostLANAddress();
                        id = id.replace("$host_ip", address.getHostAddress());
                    } else if (id.contains("$host_name")) {
                        address = DefaultGeoServerNodeInfo.getLocalHostLANAddress();
                        id = id.replace("$host_name", address.getHostName());
                    }
                }
                NODE_ID = id;
                String bgcolor = options.get("background");
                if (bgcolor == null) {
                    bgcolor = "#dadada";
                }
                String style = DEFAULT_NODE_ID_TEMPLATE.replace("$background", bgcolor);
                String color = options.get("color");
                if (color == null) {
                    color = "#0076a1";
                }
                NODE_ID_STYLE = style.replace("$color", color);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to parse GEOSERVER_NODE_OPTS, expected syntax is id:<nodeid>;color:<css_color>, but got " + property + " instead. Disabling NODE_ID GUI element");
                NODE_ID = null;
                NODE_ID_STYLE = null;
            }
        }
    }

    static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> inetAddrs = ni.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address");
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    private static Map<String, String> parseProperties(String property) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List kvps = KvpUtils.escapedTokens((String)property, (char)';');
        for (String kvp : kvps) {
            List kv = KvpUtils.escapedTokens((String)kvp, (char)':', (int)2);
            String key = ((String)kv.get(0)).toLowerCase();
            String value = kv.size() == 1 ? "true" : KvpUtils.unescape((String)((String)kv.get(1)));
            properties.put(key, value);
        }
        return properties;
    }

    @Override
    public String getId() {
        return NODE_ID;
    }

    @Override
    public void customize(WebMarkupContainer container) {
        container.add(new IBehavior[]{new AttributeAppender("style", true, (IModel)new Model((Serializable)((Object)NODE_ID_STYLE)), ";")});
        container.setVisible(this.isNodeIdVisible(container));
    }

    protected boolean isNodeIdVisible(WebMarkupContainer parent) {
        if (NODE_ID == null) {
            return false;
        }
        Authentication auth = ((GeoServerSession)parent.getSession()).getAuthentication();
        if (auth == null || !auth.isAuthenticated() || auth instanceof AnonymousAuthenticationToken) {
            return false;
        }
        GeoServerSecurityManager securityManager = GeoServerApplication.get().getSecurityManager();
        return securityManager.checkAuthenticationForAdminRole(auth);
    }

    static {
        DefaultGeoServerNodeInfo.initializeFromEnviroment();
    }
}

