/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ResourceReference;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.data.resource.DataStorePanelInfo;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataAccessFactory;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.feature.type.GeometryDescriptor;

public class CatalogIconFactory
implements Serializable {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web");
    public static final ResourceReference RASTER_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/geosilk/raster.png");
    public static final ResourceReference VECTOR_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/geosilk/vector.png");
    public static final ResourceReference MAP_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/geosilk/map.png");
    public static final ResourceReference MAP_STORE_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/geosilk/server_map.png");
    public static final ResourceReference POINT_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/silk/bullet_blue.png");
    public static final ResourceReference LINE_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/silk/line_blue.png");
    public static final ResourceReference POLYGON_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/silk/shape_square_blue.png");
    public static final ResourceReference GEOMETRY_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/geosilk/vector.png");
    public static final ResourceReference UNKNOWN_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/silk/error.png");
    public static final ResourceReference GROUP_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/silk/layers.png");
    public static final ResourceReference DISABLED_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/silk/error.png");
    public static final ResourceReference ENABLED_ICON = new ResourceReference(GeoServerBasePage.class, "img/icons/silk/tick.png");
    static final CatalogIconFactory INSTANCE = new CatalogIconFactory();

    public static final CatalogIconFactory get() {
        return INSTANCE;
    }

    private CatalogIconFactory() {
    }

    public ResourceReference getLayerIcon(LayerInfo info) {
        ResourceReference icon = UNKNOWN_ICON;
        if (info.getType() == PublishedType.VECTOR) {
            icon = VECTOR_ICON;
        } else if (info.getType() == PublishedType.RASTER) {
            icon = RASTER_ICON;
        }
        return icon;
    }

    public ResourceReference getSpecificLayerIcon(LayerInfo info) {
        if (info.getType() == PublishedType.RASTER) {
            return RASTER_ICON;
        }
        if (info.getType() == PublishedType.VECTOR) {
            try {
                FeatureTypeInfo fti = (FeatureTypeInfo)info.getResource();
                GeometryDescriptor gd = fti.getFeatureType().getGeometryDescriptor();
                return this.getVectoryIcon(gd);
            }
            catch (Exception e) {
                return GEOMETRY_ICON;
            }
        }
        if (info.getType() == PublishedType.WMS) {
            return MAP_ICON;
        }
        return UNKNOWN_ICON;
    }

    public ResourceReference getVectoryIcon(GeometryDescriptor gd) {
        if (gd == null) {
            return GEOMETRY_ICON;
        }
        Class geom = gd.getType().getBinding();
        return this.getVectorIcon(geom);
    }

    public ResourceReference getVectorIcon(Class geom) {
        if (Point.class.isAssignableFrom(geom) || MultiPoint.class.isAssignableFrom(geom)) {
            return POINT_ICON;
        }
        if (LineString.class.isAssignableFrom(geom) || MultiLineString.class.isAssignableFrom(geom)) {
            return LINE_ICON;
        }
        if (Polygon.class.isAssignableFrom(geom) || MultiPolygon.class.isAssignableFrom(geom)) {
            return POLYGON_ICON;
        }
        return GEOMETRY_ICON;
    }

    public ResourceReference getStoreIcon(StoreInfo storeInfo) {
        Object factoryClass = null;
        Catalog catalog = storeInfo.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        if (storeInfo instanceof DataStoreInfo) {
            DataAccessFactory dataStoreFactory = null;
            try {
                dataStoreFactory = resourcePool.getDataStoreFactory((DataStoreInfo)storeInfo);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "factory class for storeInfo " + storeInfo.getName() + " not found", e);
            }
            if (dataStoreFactory != null) {
                return this.getStoreIcon(dataStoreFactory.getClass());
            }
        } else if (storeInfo instanceof CoverageStoreInfo) {
            AbstractGridFormat format = resourcePool.getGridCoverageFormat((CoverageStoreInfo)storeInfo);
            if (format != null) {
                return this.getStoreIcon(format.getClass());
            }
        } else {
            if (storeInfo instanceof WMSStoreInfo) {
                return MAP_STORE_ICON;
            }
            throw new IllegalStateException(storeInfo.getClass().getName());
        }
        LOGGER.info("Could not determine icon for StoreInfo " + storeInfo.getName() + ". Using 'unknown' icon.");
        return UNKNOWN_ICON;
    }

    public ResourceReference getStoreIcon(Class<?> factoryClass) {
        List<DataStorePanelInfo> infos = GeoServerApplication.get().getBeansOfType(DataStorePanelInfo.class);
        for (DataStorePanelInfo panelInfo : infos) {
            if (!factoryClass.equals(panelInfo.getFactoryClass())) continue;
            return new ResourceReference(panelInfo.getIconBase(), panelInfo.getIcon());
        }
        if (DataAccessFactory.class.isAssignableFrom(factoryClass)) {
            for (DataStorePanelInfo panelInfo : infos) {
                if (!"defaultVector".equals(panelInfo.getId())) continue;
                return new ResourceReference(panelInfo.getIconBase(), panelInfo.getIcon());
            }
            return new ResourceReference(GeoServerApplication.class, "img/icons/geosilk/database_vector.png");
        }
        if (Format.class.isAssignableFrom(factoryClass)) {
            for (DataStorePanelInfo panelInfo : infos) {
                if (!"defaultRaster".equals(panelInfo.getId())) continue;
                return new ResourceReference(panelInfo.getIconBase(), panelInfo.getIcon());
            }
            return new ResourceReference(GeoServerApplication.class, "img/icons/geosilk/page_white_raster.png");
        }
        throw new IllegalArgumentException("Unrecognized store format class: " + factoryClass);
    }

    public ResourceReference getEnabledIcon() {
        return ENABLED_ICON;
    }

    public ResourceReference getDisabledIcon() {
        return DISABLED_ICON;
    }
}

