/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.PageRequestTarget;
import org.geoserver.security.AdminRequest;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.WicketCallback;

public class AdminRequestWicketCallback
implements WicketCallback {
    @Override
    public void onBeginRequest() {
        AdminRequest.start((Object)this);
    }

    @Override
    public void onEndRequest() {
        AdminRequest.finish();
    }

    @Override
    public void onAfterTargetsDetached() {
    }

    @Override
    public void onRequestTargetSet(IRequestTarget requestTarget) {
        Class<?> pageClass = null;
        if (requestTarget instanceof PageRequestTarget) {
            pageClass = ((PageRequestTarget)requestTarget).getPage().getPageClass();
        }
        if (requestTarget instanceof IBookmarkablePageRequestTarget) {
            pageClass = ((IBookmarkablePageRequestTarget)requestTarget).getPageClass();
        }
        if (requestTarget instanceof AjaxRequestTarget) {
            Page p = ((AjaxRequestTarget)requestTarget).getPage();
            Class<?> clazz = pageClass = p != null ? p.getClass() : null;
        }
        if (pageClass == null || !GeoServerSecuredPage.class.isAssignableFrom(pageClass) && !GeoServerHomePage.class.isAssignableFrom(pageClass)) {
            AdminRequest.abort();
        }
    }

    @Override
    public void onRuntimeException(Page page, RuntimeException e) {
    }
}

