/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.restlet.data.MediaType;
import org.restlet.resource.OutputRepresentation;

public class TemplateRepresentation
extends OutputRepresentation {
    private String templateName;
    private Configuration config;
    private Object dataModel;

    public TemplateRepresentation(String templateName, Configuration config, Object dataModel, MediaType mediaType) {
        super(mediaType);
        this.config = config;
        this.dataModel = dataModel;
        this.templateName = templateName;
    }

    public Object getDataModel() {
        return this.dataModel;
    }

    public Object setDataModel(Object dataModel) {
        this.dataModel = dataModel;
        return dataModel;
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedWriter tmplWriter = null;
        try {
            Template template = this.config.getTemplate(this.templateName);
            tmplWriter = this.getCharacterSet() != null ? new BufferedWriter(new OutputStreamWriter(outputStream, this.getCharacterSet().getName())) : new BufferedWriter(new OutputStreamWriter(outputStream, template.getEncoding()));
            template.process(this.getDataModel(), (Writer)tmplWriter);
            ((Writer)tmplWriter).flush();
        }
        catch (TemplateException te) {
            throw new IOException("Template processing error " + te.getMessage());
        }
    }
}

