/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.statistics;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;
import org.geowebcache.storage.blobstore.memory.MemoryBlobStore;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.StringRepresentation;

public class MemoryCacheStatsResource
extends Resource {
    public static Log LOG = LogFactory.getLog(MemoryCacheStatsResource.class);
    private BlobStore store;

    public void setBlobStore(BlobStore store) {
        this.store = store;
    }

    public boolean allowGet() {
        return true;
    }

    public boolean allowPut() {
        return false;
    }

    public boolean allowPost() {
        return false;
    }

    public boolean allowDelete() {
        return false;
    }

    public void handleGet() {
        Request request = this.getRequest();
        Response response = this.getResponse();
        String formatExtension = (String)request.getAttributes().get("extension");
        if (this.store != null && this.store instanceof MemoryBlobStore) {
            JsonRepresentation representation;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Memory Blobstore found, now getting statistics");
            }
            MemoryBlobStore memoryStore = (MemoryBlobStore)this.store;
            CacheStatistics stats = memoryStore.getCacheStatistics();
            CacheStatistics statistics = new CacheStatistics(stats);
            if ("json".equals(formatExtension)) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Statistics requested in JSON format");
                    }
                    representation = this.getJsonRepresentation(statistics);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            } else if ("xml".equals(formatExtension)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Statistics requested in XML format");
                }
                representation = this.getXmlRepresentation(statistics);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Statistics requested in a bad format");
                }
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unknown or missing format extension : " + formatExtension);
                return;
            }
            response.setEntity((Representation)representation);
            response.setStatus(Status.SUCCESS_OK);
        } else {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "No statistics available for the current BlobStore: " + this.store.getClass());
        }
    }

    private JsonRepresentation getJsonRepresentation(CacheStatistics stats) throws JSONException {
        XStream xs = MemoryCacheStatsResource.getConfiguredXStream((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()));
        JSONObject obj = new JSONObject(xs.toXML((Object)stats));
        JsonRepresentation rep = new JsonRepresentation(obj);
        return rep;
    }

    private Representation getXmlRepresentation(CacheStatistics stats) {
        XStream xStream = MemoryCacheStatsResource.getConfiguredXStream((XStream)new GeoWebCacheXStream());
        String xml = xStream.toXML((Object)stats);
        return new StringRepresentation((CharSequence)xml, MediaType.TEXT_XML);
    }

    public static XStream getConfiguredXStream(XStream xs) {
        xs.setMode(1001);
        xs.alias("gwcInMemoryCacheStatistics", CacheStatistics.class);
        return xs;
    }
}

