/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.seed.GWCSeedingRestlet;
import org.geowebcache.rest.seed.SeedFormRestlet;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;

public class SeedRestlet
extends GWCSeedingRestlet {
    private static Log log = LogFactory.getLog(SeedFormRestlet.class);
    private TileBreeder seeder;

    @Override
    public void doGet(Request req, Response resp) throws RestletException {
        String layerName;
        JsonRepresentation rep = null;
        if (req.getAttributes().containsKey("layer")) {
            try {
                layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        } else {
            layerName = null;
        }
        try {
            long[][] list;
            GeoWebCacheXStream xs = new GeoWebCacheXStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
            JSONObject obj = null;
            if (null == layerName) {
                list = this.seeder.getStatusList();
            } else {
                try {
                    this.seeder.findTileLayer(layerName);
                }
                catch (GeoWebCacheException e) {
                    throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
                }
                list = this.seeder.getStatusList(layerName);
            }
            obj = new JSONObject(xs.toXML((Object)list));
            rep = new JsonRepresentation(obj);
        }
        catch (JSONException jse) {
            jse.printStackTrace();
        }
        resp.setEntity(rep);
    }

    @Override
    protected void handleRequest(Request req, Response resp, Object obj) {
        SeedRequest sr = (SeedRequest)obj;
        String layerName = null;
        try {
            layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            this.seeder.seed(layerName, sr);
        }
        catch (IllegalArgumentException e) {
            throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
        }
        catch (GeoWebCacheException e) {
            throw new RestletException(e.getMessage(), Status.SERVER_ERROR_INTERNAL);
        }
    }

    public void setTileBreeder(TileBreeder seeder) {
        this.seeder = seeder;
    }
}

