/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import com.thoughtworks.xstream.XStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.config.Configuration;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.seed.GWCSeedingRestlet;
import org.geowebcache.seed.MassTruncateRequest;
import org.geowebcache.seed.TruncateLayerRequest;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class MassTruncateRestlet
extends GWCSeedingRestlet {
    private static Log log = LogFactory.getLog(MassTruncateRestlet.class);
    private StorageBroker broker;
    private Configuration config;
    static final Class<?>[] DEFAULT_REQUEST_TYPES = new Class[]{TruncateLayerRequest.class};
    Class<?>[] requestTypes;

    @Override
    public void doGet(Request req, Response resp) throws RestletException {
        StringRepresentation rep = null;
        XStream xs = this.configXStream((XStream)new GeoWebCacheXStream());
        StringBuilder sb = new StringBuilder();
        HashSet<String> result = new HashSet<String>();
        sb.append("<massTruncateRequests href=\"").append(req.getResourceRef().toString(false, false)).append("\">");
        for (Class<?> requestType : this.getRequestTypes()) {
            String alias = xs.getMapper().serializedClass(requestType);
            sb.append(" <requestType>");
            sb.append(alias);
            sb.append("</requestType>");
            if (result.add(alias) || !log.isWarnEnabled()) continue;
            log.warn((Object)("Duplicate MassTruncate Request type: " + alias));
        }
        sb.append("</massTruncateRequests>");
        rep = new StringRepresentation((CharSequence)sb.toString());
        rep.setMediaType(MediaType.APPLICATION_XML);
        resp.setEntity((Representation)rep);
    }

    @Override
    protected void handleRequest(Request req, Response resp, Object obj) {
        MassTruncateRequest mtr = (MassTruncateRequest)obj;
        try {
            if (!mtr.doTruncate(this.broker, this.config)) {
                throw new RestletException("Truncation failed", Status.SERVER_ERROR_INTERNAL);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
        }
        catch (StorageException e) {
            throw new RestletException(e.getMessage(), Status.SERVER_ERROR_INTERNAL);
        }
    }

    public void setStorageBroker(StorageBroker broker) {
        this.broker = broker;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        if (this.config == null) {
            return this.xmlConfig;
        }
        return this.config;
    }

    protected Class<?>[] getRequestTypes() {
        if (this.requestTypes == null) {
            this.requestTypes = DEFAULT_REQUEST_TYPES;
        }
        return this.requestTypes;
    }

    @Override
    protected XStream configXStream(XStream xs) {
        xs = super.configXStream(xs);
        xs.processAnnotations((Class[])this.getRequestTypes());
        return xs;
    }

    public void setRequestTypes(Set<Class<?>> requestTypes) {
        this.requestTypes = requestTypes.toArray(new Class[requestTypes.size()]);
    }
}

